/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboards.analytics.amplitude;

import com.amplitude.Amplitude;
import com.amplitude.Event;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.Partner;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.roninpixels.dashboards.analytics.amplitude.AnalyticsInfoProvider;
import com.roninpixels.dashboards.analytics.amplitude.AnalyticsService;
import com.roninpixels.dashboards.analytics.amplitude.AnalyticsStateProvider;
import com.roninpixels.dashboards.analytics.amplitude.EventDetails;
import com.roninpixels.dashboards.analytics.amplitude.HashUtils;
import java.time.ZonedDateTime;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsServiceImpl
implements AnalyticsService {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsServiceImpl.class);
    private HostLicenseInformation hostLicenseInformation;
    private PluginLicenseManager licenseManager;
    private final String amplitudekey;
    private AnalyticsInfoProvider infoProvider;
    private final Amplitude mAmplitude;
    private final AnalyticsStateProvider analyticsStateProvider;

    public AnalyticsServiceImpl(PluginLicenseManager licenseManager, HostLicenseInformation hostLicenseInformation, AnalyticsInfoProvider infoProvider, String amplitudekey, AnalyticsStateProvider analyticsStateProvider) {
        this.licenseManager = licenseManager;
        this.hostLicenseInformation = hostLicenseInformation;
        this.infoProvider = infoProvider;
        this.amplitudekey = amplitudekey;
        this.analyticsStateProvider = analyticsStateProvider;
        if (amplitudekey == null || amplitudekey.isEmpty()) {
            this.mAmplitude = null;
            return;
        }
        this.mAmplitude = Amplitude.getInstance(amplitudekey);
        this.mAmplitude.init(amplitudekey);
    }

    @Override
    public void addEvent(EventDetails eventDetails) {
        if (this.mAmplitude == null || this.analyticsStateProvider.isAnalyticsDisabled()) {
            log.debug(this.analyticsStateProvider.isAnalyticsDisabled() ? "Analytics global settings disabled" : "Amplitude key is not defined");
            return;
        }
        try {
            PluginLicense license = null;
            if (this.licenseManager.getLicense().isDefined()) {
                license = (PluginLicense)this.licenseManager.getLicense().get();
            }
            String userId = this.getUserId();
            String HostServerId = this.infoProvider.getServerId();
            String PluginLicenseSEN = "unavailable";
            if (this.hostLicenseInformation.hostSen().isDefined()) {
                PluginLicenseSEN = (String)this.hostLicenseInformation.hostSen().get();
            }
            this.groupsIdentify(this.mAmplitude, userId, HostServerId, PluginLicenseSEN);
            Event event = new Event(eventDetails.getEventName(), userId, HostServerId);
            if (eventDetails.getEventData() != null && !eventDetails.getEventData().isEmpty()) {
                JSONObject eventProps = new JSONObject();
                for (Map.Entry<String, Object> entry : eventDetails.getEventData().entrySet()) {
                    eventProps.put(entry.getKey(), entry.getValue());
                }
                event.eventProperties = eventProps;
            }
            this.mAmplitude.logEvent(event);
        }
        catch (Exception e) {
            log.debug("Error while making analytics call : " + e.getMessage());
        }
    }

    private void groupsIdentify(Amplitude client, String userId, String HostServerId, String PluginLicenseSEN) {
        try {
            JSONObject hostGroup = new JSONObject().put("host", HostServerId);
            Event hostGroupEvent = new Event("$identify", userId);
            hostGroupEvent.groups = hostGroup;
            client.logEvent(hostGroupEvent);
            JSONObject licenseGroup = new JSONObject().put("license", PluginLicenseSEN);
            Event licenseGroupEvent = new Event("$identify", userId);
            licenseGroupEvent.groups = licenseGroup;
            client.logEvent(licenseGroupEvent);
            Event hostGroupIdentify = new Event("$groupidentify", userId);
            hostGroupIdentify.groups = hostGroup;
            hostGroupIdentify.groupProperties = this.getHostDetails(this.hostLicenseInformation);
            client.logEvent(hostGroupIdentify);
            Event licenseGroupIdentify = new Event("$groupidentify", userId);
            licenseGroupIdentify.groups = licenseGroup;
            licenseGroupIdentify.groupProperties = this.getLicenseDetails(this.hostLicenseInformation, this.licenseManager);
            client.logEvent(licenseGroupIdentify);
        }
        catch (Exception e) {
            log.error("Error while group identify " + e.getMessage());
        }
    }

    private String getUserId() {
        String hostServerId = this.infoProvider.getServerId();
        String userId = this.infoProvider.getUserId();
        if (userId == null) {
            userId = "";
        }
        return HashUtils.md5Hex(hostServerId + userId);
    }

    @Override
    public String getHashedUserId() {
        return this.getUserId();
    }

    private boolean isTestInstance(Object type) {
        return type == null || type.toString().trim().length() > 0 && (type.toString().equalsIgnoreCase("DEVELOPER") || type.toString().equalsIgnoreCase("TESTING"));
    }

    private JSONObject getHostDetails(HostLicenseInformation hostLicenseInformation) {
        JSONObject hostDetails = new JSONObject();
        String urlBase = this.infoProvider.getHostBaseURL();
        hostDetails.put("base_url", urlBase);
        hostDetails.put("display_url", urlBase);
        hostDetails.put("ecosystem", "atlassian");
        hostDetails.put("parent_product", this.infoProvider.getHostProduct());
        hostDetails.put("test_instance", this.isTestInstance(this.infoProvider.getLicenseType()));
        return hostDetails;
    }

    private JSONObject getLicenseDetails(HostLicenseInformation hostLicenseInformation, PluginLicenseManager licenseManager) {
        JSONObject licenseDetails = new JSONObject();
        licenseDetails.put("marketplace_source", "Atlassian");
        if (licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)licenseManager.getLicense().get();
            licenseDetails.put("app_key", pluginLicense.getPluginKey());
            licenseDetails.put("approx_user_count", pluginLicense.getMaximumNumberOfUsers().isDefined() ? -1 : (Integer)pluginLicense.getMaximumNumberOfUsers().get());
            licenseDetails.put("company", pluginLicense.getOrganization().getName());
            if (pluginLicense.getContacts().iterator().hasNext()) {
                licenseDetails.put("contact_user_email", ((Contact)pluginLicense.getContacts().iterator().next()).getEmail());
                licenseDetails.put("contact_user_name", ((Contact)pluginLicense.getContacts().iterator().next()).getName());
            }
            licenseDetails.put("host_license_id", hostLicenseInformation.hostSen());
            licenseDetails.put("hosting", "datacenter");
            licenseDetails.put("is_eval", pluginLicense.isEvaluation());
            licenseDetails.put("last_updated", pluginLicense.getCreationZonedDate().toLocalDate());
            licenseDetails.put("license_type", pluginLicense.getLicenseTypeDescriptionKey());
            licenseDetails.put("maintenance_end_date", ((ZonedDateTime)pluginLicense.getMaintenanceExpiryZonedDate().get()).toLocalDate());
            licenseDetails.put("maintenance_start_date", pluginLicense.getPurchaseZonedDate().toLocalDate());
            licenseDetails.put("partner_name", pluginLicense.getPartner().isDefined() ? ((Partner)pluginLicense.getPartner().get()).getName() : "no");
            licenseDetails.put("status", pluginLicense.isActive() ? "active" : "inactive");
        }
        return licenseDetails;
    }
}

