/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.jira.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.web.rest.base.jira.api.GenericJiraEndpoint;
import java.util.Collections;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jira/v1/projects")
public class ProjectsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ProjectsEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @Produces(value={"application/json"})
    public Response getProjects(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @QueryParam(value="query") String query) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            if (query != null && !query.trim().equals("")) {
                return GenericJiraEndpoint.generateResponse(jira.getFilteredProjects(query));
            }
            return GenericJiraEndpoint.generateResponse(jira.getProjects(Collections.emptyMap()));
        }
        catch (Exception e) {
            log.error("Problems getting projects for a datasource", (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getProjectById(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull @PathParam(value="id") String id) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            return GenericJiraEndpoint.generateResponse(jira.getProject(id));
        }
        catch (Exception e) {
            log.error("Problems getting the project versions. Project -> " + id, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

