/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.management;

import com.roninpixels.dashboardhub.config.frontedModel.FeatureManagementSettingsModel;
import com.roninpixels.dashboardhub.controllers.FeatureManagementController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.management.FeatureManagementSettingsMsg;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureManagementEndpoint {
    private static final Logger log = LoggerFactory.getLogger(FeatureManagementEndpoint.class);
    @Inject
    private FeatureManagementController featureManagementController;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private DHObjectMapper mapper;

    public Response setFeatureManagementConfiguration(String message) {
        FeatureManagementSettingsMsg newConfig;
        if (!this.dhUserService.isLoggedUserAdmin().booleanValue()) {
            return Response.status((int)403).build();
        }
        try {
            newConfig = this.mapper.readValue(message, FeatureManagementSettingsMsg.class);
        }
        catch (Exception e) {
            log.error("Problems with the message format", (Throwable)e);
            return Response.status((int)400).build();
        }
        try {
            FeatureManagementSettingsModel featureManagementSettingsModel = new FeatureManagementSettingsModel();
            featureManagementSettingsModel.setLegacyFeatures(newConfig.getFeatureManagement().getLegacyFeatures());
            featureManagementSettingsModel.setAnalytics(newConfig.getFeatureManagement().isAnalytics());
            this.featureManagementController.updateFeatureManagementSettings(featureManagementSettingsModel);
            HashMap<String, Boolean> responseData = new HashMap<String, Boolean>();
            responseData.put("ok", true);
            return ResponseBuilder.ok(responseData).build();
        }
        catch (Exception e) {
            log.error("Problems updating the feature management configuration", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

