/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources;

import com.roninpixels.dashboardhub.controllers.DatasourceSettingsController;
import com.roninpixels.dashboardhub.controllers.DatasourcesControllerV2;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.exceptions.BadDatasourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.services.DHDefaultConfigGenerator;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources.CreateDatasourceMessage;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources.DatasourcesResponse;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.datasources.ResponseValue;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DatasourceEndpointSrv {
    private static final Logger log = LoggerFactory.getLogger(DatasourceEndpointSrv.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private Crypto crypto;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private DatasourcesControllerV2 dsController;
    @Inject
    private DHDefaultConfigGenerator defaultConfiguration;
    @Inject
    private DatasourceSettingsController datasourceSettingsController;
    @Inject
    private DHObjectMapper mapper;

    private static void removeToken(DatasourceModel ds) {
        if (ds != null) {
            ds.setToken(null);
        }
    }

    private static void removeRestriction(DatasourceModel ds) {
        if (ds != null) {
            ds.setRestrictionType(ds.getRestrictions() != null ? ds.getRestrictions().getType() : (ds.getPrivate() != null && ds.getPrivate() != false ? "someUseSomeEdit" : "anyUseSomeEdit"));
            ds.setRestrictions(null);
        }
    }

    private static void removeTokens(List<DatasourceModel> dsList) {
        dsList.stream().forEach(DatasourceEndpointSrv::removeToken);
    }

    private static void removeRestrictions(List<DatasourceModel> dsList) {
        dsList.stream().forEach(DatasourceEndpointSrv::removeRestriction);
    }

    public Response getDatasourceWithExtraInfo(String id) {
        try {
            DatasourceModel ds = this.dsController.getDatasourceWithExtraInfo(id);
            DatasourceEndpointSrv.removeToken(ds);
            return ds == null ? Response.status((int)404).build() : ResponseBuilder.ok(ds).build();
        }
        catch (DhUserException dhe) {
            return ResponseBuilder.createErrorResponseFrom(dhe);
        }
        catch (Exception e) {
            log.error("Problems getting a datasource: " + id);
            return Response.status((int)500).build();
        }
    }

    public Response create(CreateDatasourceMessage message) {
        String encryptedData = message.getEncrypted();
        try {
            AppUser user = this.dhUserService.getLoggedInUser();
            if (!this.datasourceSettingsController.canUserCreateDatasources(user.getKey())) {
                throw new DhUserException(403, "NOT_ALLOWED_DATASOURCE_CREATION", "The current user cannot create datasources");
            }
            String data = this.crypto.decryptFrontend(encryptedData);
            DatasourceModel model = this.mapper.readValue(data, DatasourceModel.class);
            if (model.getId() == null) {
                model.setId(UUID.randomUUID().toString());
            }
            if (model.getCreated() == null) {
                model.setCreated(new Date());
            }
            if (model.getCreator() == null) {
                model.setCreator(user.getKey());
            }
            if (model.getRestrictions() == null) {
                model.setRestrictions(DatasourcesUtil.createDefaultDatasourceRestrictions());
            }
            DatasourcesUtil.setPrivateBasedOnRestrictionType(model);
            if (model.getProduct() == null && !model.getType().equals("token") && !model.getType().equals("dashboard")) {
                model.setProduct(model.getType());
            }
            boolean isDefault = Boolean.TRUE.equals(model.getFirst()) && model.getOptions() == null && this.defaultConfiguration.getDefaultDatasource() == null;
            DatasourceModel created = null;
            if (isDefault) {
                this.defaultConfiguration.ensureDefaultDatasource();
            } else {
                created = this.dsController.addDatasource(model);
            }
            if (created != null) {
                List<DatasourceModel> datasources = this.dsController.getDatasources(user.getKey());
                DatasourceEndpointSrv.removeTokens(datasources);
                DatasourceEndpointSrv.removeRestrictions(datasources);
                ResponseValue resValue = new ResponseValue(datasources);
                return ResponseBuilder.ok(resValue).build();
            }
            log.warn("A datasource wasn't added -> " + model.getName());
            return Response.status((int)400).build();
        }
        catch (DhUserException dhe) {
            return ResponseBuilder.createErrorResponseFrom(dhe);
        }
        catch (Exception e) {
            log.error("Problems adding a datasource", (Throwable)e);
            return ResponseBuilder.createParseErrorResponse(e);
        }
    }

    public Response update(String dsId, CreateDatasourceMessage message) {
        String encryptedData = message.getEncrypted();
        try {
            String data = this.crypto.decryptFrontend(encryptedData);
            DatasourceModel model = this.mapper.readValue(data, DatasourceModel.class);
            model.setId(dsId);
            if (model.getId() == null || model.getId().trim().isEmpty()) {
                throw new BadDatasourceException(String.format("The datasource id cannot be null: '%s'", model.getId()));
            }
            DatasourcesUtil.setPrivateBasedOnRestrictionType(model);
            DatasourceModel updated = this.dsController.updateDatasource(model);
            if (updated != null) {
                DatasourceModel datasource = this.dsController.getDatasource(model.getId());
                DatasourceEndpointSrv.removeToken(datasource);
                DatasourceEndpointSrv.removeRestriction(datasource);
                return ResponseBuilder.ok(datasource).build();
            }
            log.warn("A datasource wasn't updated -> " + model.getName());
            return Response.status((int)400).build();
        }
        catch (BadDatasourceException bde) {
            log.error("Problems updating a datasource", (Throwable)bde);
            return ResponseBuilder.createParseErrorResponse(bde);
        }
        catch (DhUserException dhe) {
            return ResponseBuilder.createErrorResponseFrom(dhe);
        }
        catch (Exception e) {
            log.error("Problems updating a datasource", (Throwable)e);
            return ResponseBuilder.createParseErrorResponse(e);
        }
    }

    public Response delete(String id) {
        try {
            DatasourceModel ds = this.dsController.removeDatasource(id);
            if (ds == null) {
                throw new DhUserException(404, "DATASOURCE_NOT_FOUND", "");
            }
            List<DatasourceModel> datasources = this.dsController.getDatasources(ds.getCreator());
            DatasourceEndpointSrv.removeTokens(datasources);
            DatasourceEndpointSrv.removeRestrictions(datasources);
            ResponseValue resValue = new ResponseValue(datasources);
            return ResponseBuilder.create(204, resValue).build();
        }
        catch (DhUserException dhe) {
            return ResponseBuilder.createErrorResponseFrom(dhe);
        }
        catch (Exception e) {
            log.error("Problems deleting a datasource: " + id, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response getDatasources(String wallBoardBehave) {
        try {
            String userKey = null;
            Object tokenContent = null;
            if (wallBoardBehave != null && !"undefined".equals(wallBoardBehave)) {
                return ResponseBuilder.ok(new DatasourcesResponse("datasources", new ResponseValue())).build();
            }
            AppUser user = this.dhUserService.getLoggedInUser();
            if (user != null) {
                userKey = user.getKey();
            }
            if (userKey == null) {
                return Response.status((int)404).build();
            }
            List<DatasourceModel> datasources = this.dsController.getDatasources(userKey);
            if (!datasources.stream().anyMatch(DatasourceModel::getFirst)) {
                this.defaultConfiguration.ensureDefaultDatasource();
                datasources = this.dsController.getDatasources(userKey);
            }
            DatasourceEndpointSrv.removeTokens(datasources);
            DatasourceEndpointSrv.removeRestrictions(datasources);
            ResponseValue value = new ResponseValue(datasources);
            return ResponseBuilder.ok(new DatasourcesResponse("datasources", value)).build();
        }
        catch (DhUserException dhe) {
            return ResponseBuilder.createErrorResponseFrom(dhe);
        }
        catch (Exception e) {
            log.error("Problems getting datasources", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

