/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.customReports;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.roninpixels.dashboardhub.app.RequestFactoryWrapper;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.services.DHSessionHandler;
import com.roninpixels.dashboardhub.services.DHWhitelistService;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRProxyRequesterEndpoint {
    private static final Logger log = LoggerFactory.getLogger(CRProxyRequesterEndpoint.class);
    @Inject
    private DHSessionHandler dhSessionHandler;
    @Inject
    private RequestFactoryWrapper requestFactoryWrapper;

    public Response proxyGet(HttpServletRequest req, String dhSession) {
        try {
            this.dhSessionHandler.validateDhSession(dhSession);
        }
        catch (Exception e) {
            return ResponseBuilder.create(401).build();
        }
        String url = req.getParameter("url");
        try {
            return (Response)this.requestFactoryWrapper.createRequest(Request.MethodType.GET, url).executeAndReturn(new ReturningResponseHandler(){

                public Object handle(com.atlassian.sal.api.net.Response response) throws ResponseException {
                    Map headers = response.getHeaders();
                    Response.ResponseBuilder builder = ResponseBuilder.ok(response.getResponseBodyAsStream());
                    headers.entrySet().stream().filter(entry -> DHWhitelistService.ALLOWED_HEADERS.contains(entry.getKey())).forEach(entry -> builder.header((String)entry.getKey(), entry.getValue()));
                    return builder.build();
                }
            });
        }
        catch (DhUserException due) {
            return ResponseBuilder.createErrorResponseFrom(due);
        }
        catch (Exception e) {
            log.error("Problems with a request at proxy", (Throwable)e);
            return Response.status((int)404).build();
        }
    }
}

