/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.atlassianInsight.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.AtlassianInsightConnector;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/atlassian-insight/v1/iql")
public class IQLEndpoint {
    private static final Logger log = LoggerFactory.getLogger(IQLEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @Produces(value={"application/json"})
    public Response iqlSearch(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull @QueryParam(value="iql") String iql) {
        if (!this.checkParams(datasourceinfo, iql)) {
            return Response.status((int)400).build();
        }
        try {
            AtlassianInsightConnector connector = (AtlassianInsightConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("iql", iql);
            ResponseEntity<Map> response = connector.searchByIQL(params);
            int status = response.getStatusCode().value();
            if (status < 400) {
                return Response.status((int)status).entity(response.getBody()).build();
            }
            return Response.status((int)400).entity(response.getBody()).build();
        }
        catch (Exception e) {
            log.error("Problems executing an IQL", (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    private boolean checkParams(String datasourceinfo, String iql) {
        return datasourceinfo != null && iql != null;
    }
}

