/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.roninpixels.dashboardhub.config.action.DHShowAction;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroDashboardServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MacroDashboardServlet.class);
    private static final String RESOURCE = "resources";
    private static final String TEMPLATE_PATH_VIEWER = "/templates/gadget-config.vm";
    private static final String TEMPLATE_PATH_EDITOR = "/templates/dashboard-hub-main.vm";
    @ComponentImport
    private TemplateRenderer templateRenderer;
    @Inject
    private Provider<DHShowAction> actionProvider;
    @Inject
    private BoardsController boardsController;
    @Inject
    private DHObjectMapper mapper;
    private String resources;

    @Inject
    public MacroDashboardServlet(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void init() {
        this.resources = this.getServletConfig().getInitParameter(RESOURCE);
    }

    private String getSerializedBoard(String boardId) throws IOException {
        BoardModel board = this.boardsController.getBoard(boardId);
        if (board == null) {
            return "";
        }
        String rawBoard = this.mapper.writeValueAsString(board);
        return Base64.getEncoder().encodeToString(rawBoard.getBytes(StandardCharsets.UTF_8));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("resp", resp);
        context.put("urlMode", UrlMode.AUTO);
        context.put("scope", Collections.singletonList(this.resources));
        DHShowAction action = (DHShowAction)this.actionProvider.get();
        context.put("dh", action);
        context.put("action", action);
        String board = this.getSerializedBoard(req.getParameter("boardId"));
        if (board != "") {
            context.put("macroBoard", board);
        }
        boolean isEditor = Boolean.parseBoolean(req.getParameter("isEditor"));
        HashMap<String, Boolean> globalVars = new HashMap<String, Boolean>();
        globalVars.put("isMacroEditor", isEditor);
        context.put("isMacroEditor", isEditor);
        globalVars.put("isMacro", !isEditor);
        context.put("globalVars", globalVars);
        String template = isEditor ? TEMPLATE_PATH_EDITOR : TEMPLATE_PATH_VIEWER;
        this.templateRenderer.render(template, context, (Writer)resp.getWriter());
    }
}

