/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders;

import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.AgileGadgetReponseData;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtilsSrv;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.JQLAndSprints;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.AgileGadgetConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.ConfigWithMetric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public abstract class AgileIssuesProvider {
    protected JiraConnector jiraConnector;
    @Inject
    protected JiraSprintDataUtilsSrv jiraSprintUtils;
    protected List<String> fields;
    protected String filterDateField;
    protected List<String> expandValues;

    public void setJiraConnector(JiraConnector jiraConnector) {
        this.jiraConnector = jiraConnector;
    }

    public void setStaticConfig(List<String> fields) {
        this.setStaticConfig(fields, null);
    }

    public void setStaticConfig(List<String> fields, String filterDateField) {
        this.fields = new ArrayList<String>(fields);
        this.filterDateField = filterDateField;
    }

    public void setExpand(List<String> expand) {
        this.expandValues = new ArrayList<String>(expand);
    }

    protected List<Map> getAgileData(ConfigWithMetric config, List<String> extraParams, List<Map> sprints, String filterId) {
        if (sprints.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.fields == null) {
            return Collections.emptyList();
        }
        String sprintClause = !extraParams.isEmpty() ? extraParams.get(0) : "Sprint";
        String sprintFieldKey = extraParams.size() > 1 ? extraParams.get(1) : "sprint";
        LinkedList<String> extraFields = new LinkedList<String>(this.fields);
        if (sprintFieldKey != null) {
            extraFields.add(sprintFieldKey);
        }
        if (extraParams.size() > 2) {
            List moreExtraFields = extraParams.stream().skip(2L).filter(Objects::nonNull).collect(Collectors.toList());
            extraFields.addAll(moreExtraFields);
        }
        List<Map> issues = this.jiraSprintUtils.getSprintIssues(this.jiraConnector, sprints, config.getMetric(), extraFields, sprintClause, sprintFieldKey, filterId);
        return issues;
    }

    public abstract AgileGadgetReponseData getAgileData(AgileGadgetConfig var1, List<String> var2);

    public abstract JQLAndSprints getJQLAndSprintsData(AgileGadgetConfig var1, List<String> var2);
}

