/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.GadgetBadConfigException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.SprintBlockersConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.AgileIssuesProvider;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.JQLAndSprints;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.AgileGadgetConfig;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class SprintBlockers
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(SprintBlockers.class);
    static final List<String> FIELDS = Arrays.asList("*all");
    static final List<String> COMPATIBLE_REPORTING_TYPE = Collections.unmodifiableList(Arrays.asList("boards", "sprints"));

    @Override
    protected List<String> getCompatibleReportingTypes() {
        return COMPATIBLE_REPORTING_TYPE;
    }

    AgileIssuesProvider getProvider(AgileGadgetConfig config) {
        AgileIssuesProvider provider = this.getAgileIssuesProvider(config.getReportingEntityType());
        return provider;
    }

    private boolean isPermissionFlaggedError(ResponseEntity response) {
        try {
            JQLResponse errorBody = (JQLResponse)response.getBody();
            return errorBody.getErrorMessages() != null && errorBody.getErrorMessages().stream().anyMatch(msg -> msg.indexOf("Flagged") != -1);
        }
        catch (Exception e) {
            return false;
        }
    }

    private List getBlockerIssues(String partialJQL, String sprintClause) {
        String baseJQL = "(%s) AND resolution IS EMPTY AND (issueLinkType in (\"blocks\") %s)";
        try {
            String jql = String.format("(%s) AND resolution IS EMPTY AND (issueLinkType in (\"blocks\") %s)", partialJQL, "OR Flagged = Impediment", sprintClause);
            return this.jiraConnector.execJQL(jql, FIELDS, null, null, null, "").getIssues();
        }
        catch (BadRequestToSourceException bre) {
            if (this.isPermissionFlaggedError(bre.getResponseEntity())) {
                log.warn("SprintBlockers cannot get issues with impediments. Returned error: " + bre.getResponseEntity().getBody());
                String jql = String.format("(%s) AND resolution IS EMPTY AND (issueLinkType in (\"blocks\") %s)", partialJQL, "", sprintClause);
                return this.jiraConnector.execJQL(jql, FIELDS, null, null, null, "").getIssues();
            }
            throw bre;
        }
    }

    boolean findAnyImpediment(Map<String, ?> issue, String flagField) {
        Map fields = (Map)issue.get("fields");
        List flagFieldValue = (List)fields.get(flagField);
        if (flagFieldValue != null && !flagFieldValue.isEmpty()) {
            return flagFieldValue.stream().anyMatch(field -> "Impediment".equals(field.get("value")));
        }
        return fields.entrySet().stream().filter(entry -> entry.getValue() instanceof List).map(entry -> (List)entry.getValue()).filter(value -> !value.isEmpty() && value.get(0) instanceof Map).flatMap(value -> value.stream()).anyMatch(element -> "Impediment".equals(element.get("value")));
    }

    List<Map> collectEpics(List<Map<String, ?>> issues, String epicFieldsId) {
        return issues.stream().map(issue -> {
            Map parent;
            Map parentIssueType;
            Object epicKey = ((Map)issue.get("fields")).get(epicFieldsId);
            if (epicKey != null) {
                HashMap epic = new HashMap();
                epic.put("key", epicKey);
                return epic;
            }
            if (((Map)issue.get("fields")).containsKey("parent") && (parentIssueType = (Map)(parent = (Map)((Map)issue.get("fields")).get("parent")).get("issuetype")) != null && "Epic".equals(parentIssueType.get("name"))) {
                return parent;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List getIssuesData(List<Map> epicsDef, String issueColor) {
        if (epicsDef.isEmpty()) {
            return Collections.emptyList();
        }
        String keys = epicsDef.stream().map(epicDef -> epicDef.get("key").toString()).collect(Collectors.joining(","));
        String jql = String.format("key IN (%s)", keys);
        LinkedList<String> fields = new LinkedList<String>();
        fields.add("*all");
        if (issueColor != null) {
            fields.add(issueColor);
        }
        return this.jiraConnector.execJQL(jql, fields, null, null, null, "").getIssues();
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        SprintBlockersConfig config = GadgetRequesterUtils.getConfig(gadget, SprintBlockersConfig.class);
        if (config.getReportingEntityType() == null) {
            config.setReportingEntityType("boards");
        }
        if ("boards".equals(config.getReportingEntityType())) {
            config.setnElements(1);
            config.setSprintFilter(Arrays.asList("active"));
        }
        if (config.getSprints().size() + config.getAllBoards().size() > 1) {
            throw new GadgetBadConfigException("Bad configuration: too many sprints or boards: " + gadget.getName());
        }
        String epicFieldsId = !extraParams.isEmpty() ? extraParams.get(0) : "";
        String issueColor = extraParams.size() > 0 ? extraParams.get(1) : "";
        String sprintClause = !extraParams.isEmpty() ? extraParams.get(2) : "sprint";
        AgileIssuesProvider provider = this.getProvider(config);
        JQLAndSprints aa = provider.getJQLAndSprintsData(config, Arrays.asList(sprintClause));
        List<Map> sprints = aa.getSprints();
        String partialJQL = aa.getJql();
        if (sprints.isEmpty()) {
            return Collections.emptyMap();
        }
        Map activeSprint = sprints.get(0);
        List allBlockers = this.getBlockerIssues(partialJQL, sprintClause);
        List<Map> epicsDef = this.collectEpics(allBlockers, epicFieldsId);
        List epics = epicsDef.isEmpty() ? Collections.emptyList() : this.getIssuesData(epicsDef, issueColor);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("issues", allBlockers);
        response.put("epics", epics);
        response.put("sprint", activeSprint);
        response.put("allActiveSprints", sprints);
        return response;
    }
}

