/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.EpicProgressConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Filter;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpicProgress
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(EpicProgress.class);
    static final Integer MAX_EPICS = 300;
    static final String DEFAULT_EPIC_LINK_FIELD_NAME = "Epic Link";
    static final List<String> DEFAULT_EPIC_FIELDS = Arrays.asList("status", "id", "duedate", "summary");
    static final List<String> DEFAULT_ISSUE_FIELDS = Arrays.asList("status", "id", "parent");

    protected Field getEpicLinkField() throws Exception {
        List<Field> fieldList = this.getFields();
        return fieldList.stream().filter(field -> DEFAULT_EPIC_LINK_FIELD_NAME.equalsIgnoreCase(field.getUntranslatedName()) || DEFAULT_EPIC_LINK_FIELD_NAME.equalsIgnoreCase(field.getName())).findAny().orElse(null);
    }

    protected String getEpicLinkFieldClauseName(Field epicLinkField) {
        List clauseNames = (List)epicLinkField.getOtherFields().get("clauseNames");
        return (String)clauseNames.get(0);
    }

    protected String getEpicLinkFieldClauseName() {
        try {
            Field epicLinkField = this.getEpicLinkField();
            return this.getEpicLinkFieldClauseName(epicLinkField);
        }
        catch (Exception e) {
            log.warn("Something went wrong getting the epic clauseName. Returning the default one.", (Throwable)e);
            return DEFAULT_EPIC_LINK_FIELD_NAME;
        }
    }

    List<Map> getEpics(EpicProgressConfig config, List<String> extraFields, List<Field> instanceFields) {
        List<String> fields = new LinkedList<String>(DEFAULT_EPIC_FIELDS);
        if (extraFields != null) {
            fields.addAll(extraFields);
        }
        fields = fields.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Filter filter = config.getFilter();
        String partialJql = filter.getJql();
        String entityType = config.getEntityType();
        String entityTypeClause = String.format("issuetype = \"%s\"", entityType);
        String jql = JqlUtils.appendToJql(partialJql, entityTypeClause, "AND");
        HashMap<String, Object> extraOpts = new HashMap<String, Object>();
        extraOpts.put("maxResults", MAX_EPICS);
        extraOpts.put("loadAll", false);
        return this.execJQLwithFilterFields(jql, fields, instanceFields, null, null, extraOpts, "").getIssues();
    }

    void populateWithIssues(List<Map> epics, List<String> metric, List<Field> instanceFields, List<Field> customDateFields) throws Exception {
        Field epicLinkField = this.getEpicLinkField();
        String epicLinkFieldName = this.getEpicLinkFieldClauseName(epicLinkField);
        LinkedList<String> fields = new LinkedList<String>(DEFAULT_ISSUE_FIELDS);
        fields.add(epicLinkField.getId());
        if (metric != null) {
            fields.addAll(JiraSprintDataUtils.extractFieldsNamesFromMetric(metric));
        }
        if (customDateFields != null) {
            fields.addAll(customDateFields.stream().map(Field::getId).collect(Collectors.toList()));
        }
        String epicsClause = epics.stream().map(epic -> (String)epic.get("key")).collect(Collectors.joining(","));
        String jql = String.format("\"%s\" in (%s) OR parent in (%s)", epicLinkFieldName, epicsClause, epicsClause);
        List<Map> issues = this.execJQLwithFilterFields(jql, fields, instanceFields, null, null, null, null).getIssues();
        HashMap epicKeysAndIssues = new HashMap();
        epics.forEach(epic -> {
            LinkedList epicIssues = new LinkedList();
            epic.put("issues", epicIssues);
            epicKeysAndIssues.put((String)epic.get("key"), epicIssues);
        });
        issues.stream().forEach(issue -> {
            Map issueFields = (Map)issue.get("fields");
            Map parent = (Map)issueFields.get("parent");
            String epicLink = (String)issueFields.get(epicLinkField.getId());
            String key = parent != null ? (String)parent.get("key") : epicLink;
            List siblings = (List)epicKeysAndIssues.get(key);
            siblings.add(issue);
        });
    }

    private List<Field> getDateFields(EpicProgressConfig config, List<Field> instanceFields) {
        Field endDateField;
        Field startDateField;
        ArrayList<Field> dateFields = new ArrayList<Field>();
        if (config.getStartDateField() != null && !config.getStartDateField().isEmpty() && (startDateField = (Field)instanceFields.stream().filter(field -> field.getId().equals(config.getStartDateField())).findFirst().orElse(null)) != null) {
            dateFields.add(startDateField);
        }
        if (config.getEndDateField() != null && !config.getEndDateField().isEmpty() && (endDateField = (Field)instanceFields.stream().filter(field -> field.getId().equals(config.getEndDateField())).findFirst().orElse(null)) != null) {
            dateFields.add(endDateField);
        }
        return dateFields;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        EpicProgressConfig config = GadgetRequesterUtils.getConfig(gadget, EpicProgressConfig.class);
        HashMap<String, List<Object>> responseObj = new HashMap<String, List<Object>>();
        try {
            List<Field> instanceFields = this.getFields();
            List<Field> dateFields = this.getDateFields(config, instanceFields);
            List<Map> epics = this.getEpics(config, extraParams, instanceFields);
            if (epics.isEmpty()) {
                responseObj.put("epics", new ArrayList());
                return responseObj;
            }
            this.populateWithIssues(epics, config.getMetric(), instanceFields, dateFields);
            responseObj.put("epics", epics);
            return responseObj;
        }
        catch (BadRequestToSourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

