/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.JQLFilterConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.JSMMultiprojectConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSMMultiproject
extends JSMBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(JSMMultiproject.class);

    protected List getQueueIssuesByTimeRange(String dateStr, String queueJQL, List fields, List<Field> instanceFields) {
        String jql = String.format("(created >= '%s' OR updatedDate >= '%s') AND (%s)", dateStr, dateStr, queueJQL);
        return this.execJQLwithFilterFields(jql, fields, instanceFields, null, null, null, null).getIssues();
    }

    protected List<Map> getQueues(JSMMultiprojectConfig config) {
        List<Map> queues = config.getProjectsQueues().stream().map(projectQueue -> {
            try {
                String projectId = (String)projectQueue.get("project");
                String queueId = (String)projectQueue.get("queue");
                String serviceDeskId = (String)projectQueue.get("serviceDeskId");
                return this.getQueue(projectId, queueId, serviceDeskId);
            }
            catch (Exception e) {
                throw new RuntimeException("Problems getting data", e);
            }
        }).collect(Collectors.toList());
        return queues;
    }

    protected Map getJqlQueues(JSMMultiprojectConfig config) {
        JQLFilterConfig jqlFilterConfig;
        LinkedHashMap<String, Object> jqlQueuesMap = new LinkedHashMap<String, Object>();
        if (config instanceof JQLFilterConfig && (jqlFilterConfig = (JQLFilterConfig)config).getUseJQL() != null && jqlFilterConfig.getUseJQL().booleanValue()) {
            jqlQueuesMap.put("jql", JqlUtils.getJQLwithoutOrderBy(jqlFilterConfig.getJql()));
            jqlQueuesMap.put("queues", new LinkedList());
            return jqlQueuesMap;
        }
        if (config.getProjectsQueues() == null) {
            config.setProjectQueue(config.getProject(), config.getQueue(), config.getServiceDeskId());
        }
        List<Map> queues = this.getQueues(config);
        String queuesJql = queues.stream().map(queueJql -> JqlUtils.getJQLwithoutOrderBy(queueJql.get("jql").toString())).collect(Collectors.joining(" OR "));
        jqlQueuesMap.put("jql", queuesJql);
        jqlQueuesMap.put("queues", queues);
        return jqlQueuesMap;
    }

    @Override
    public abstract Object getData(GadgetModel var1, List<String> var2);
}

