/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMMultiproject;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.AgentWorkloadConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentWorkload
extends JSMMultiproject {
    private static final Logger log = LoggerFactory.getLogger(AgentWorkload.class);
    private static final List DEFAULT_FIELDS = Arrays.asList("resolution", "assignee", "status");
    private String groupByField;

    public AgentWorkload() {
        this.groupByField = "assignee";
    }

    public AgentWorkload(String groupByField) {
        this.groupByField = groupByField;
    }

    protected List getIssues(AgentWorkloadConfig config, List<Field> fields, String dateStr, String queuesJql) {
        List _issues = config.getSlaFields().stream().map(slaField -> {
            List<Field> matchingFields = JiraDataUtils.getFieldsWithSameName(String.valueOf(slaField.get(0)), fields);
            String jqlParam = matchingFields.stream().map(matchingField -> {
                String name = (String)((List)matchingField.getOtherFields().get("clauseNames")).get(0);
                String _jql = String.format("%s = completed() AND updatedDate >= '%s' AND %s != NULL AND (%s)", name, dateStr, this.groupByField, queuesJql);
                return _jql;
            }).collect(Collectors.joining(" OR "));
            List<String> requiredFields = matchingFields.stream().map(matchingField -> matchingField.getKey() != null ? matchingField.getKey() : matchingField.getId()).collect(Collectors.toList());
            requiredFields.add(this.groupByField);
            return this.execJQLwithFilterFields(jqlParam, requiredFields, fields, null, null, null, null).getIssues();
        }).collect(Collectors.toList());
        return _issues;
    }

    protected void setSlaIssues(AgentWorkloadConfig config, Map issues, List _issues) {
        int i = 0;
        for (List<String> slaField : config.getSlaFields()) {
            issues.put(slaField.get(0), _issues.get(i));
            ++i;
        }
    }

    public Object getWorkLoadData(AgentWorkloadConfig config) {
        try {
            HashMap result = new HashMap();
            HashMap<String, List> issues = new HashMap<String, List>();
            List<Field> fields = this.getFields();
            Map jqlQueuesMap = this.getJqlQueues(config);
            String dateStr = JSMDataUtil2.getDateAsString(config.getTimeRange());
            List _issues = this.getIssues(config, fields, dateStr, (String)jqlQueuesMap.get("jql"));
            this.setSlaIssues(config, issues, _issues);
            List totals = this.getQueueIssuesByTimeRange(dateStr, (String)jqlQueuesMap.get("jql"), DEFAULT_FIELDS, fields);
            issues.put("totals", totals);
            result.put("issues", issues);
            result.put("queues", jqlQueuesMap.get("queues"));
            return result;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        AgentWorkloadConfig config = GadgetRequesterUtils.getConfig(gadget, AgentWorkloadConfig.class);
        return this.getWorkLoadData(config);
    }
}

