/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.customReports;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.factories.CustomReportsConnectorFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.CustomReportConnector;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.exceptions.GadgetBadConfigException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.FetchOptions;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class CustomReportsWidget
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(CustomReportsWidget.class);
    @Inject
    private ConnectorsProvider provider;
    @Inject
    private CustomReportsConnectorFactory connectorFactory;
    @Inject
    private DatasourcesUtil datasourcesUtil;
    private CustomReportConnector mConnector;
    private FetchOptions mFetchOptions;
    private Map<String, String> dsHeaders = new HashMap<String, String>();
    private MultiValueMap dsParams = new LinkedMultiValueMap();

    @Override
    public void init(DatasourceModel datasource, Map context) {
        List otherHeaders;
        Map otherOptions;
        List params;
        List headers;
        this.mFetchOptions = (FetchOptions)context.get("fetchOptions");
        this.mConnector = (CustomReportConnector)this.connectorFactory.createConnector(datasource);
        if (this.mConnector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + this.getClass().getAnnotation(Component.class));
        }
        DsOptionsModel dsOptions = datasource.getOptions();
        if (dsOptions == null) {
            dsOptions = this.datasourcesUtil.getSecretOptions(datasource.getToken());
        }
        if ((headers = dsOptions.getOption("headers", List.class)) != null) {
            headers.stream().forEach(header -> {
                String key = (String)header.get("key");
                String value = (String)header.get("value");
                this.dsHeaders.put(key, value);
            });
        }
        if ((params = dsOptions.getOption("params", List.class)) != null) {
            params.stream().forEach(param -> {
                String key = (String)param.get("key");
                String value = (String)param.get("value");
                this.dsParams.put((Object)key, Arrays.asList(value));
            });
        }
        if ((otherOptions = (Map)dsOptions.getOtherConfig().getOrDefault("options", null)) != null && (otherHeaders = (List)otherOptions.getOrDefault("headers", null)) != null) {
            otherHeaders.stream().forEach(header -> {
                String key = (String)header.get("key");
                String value = (String)header.get("value");
                this.dsHeaders.put(key, value);
            });
        }
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        CustomReportConnector.RequestConfig config = new CustomReportConnector.RequestConfig();
        try {
            URI dsURI = new URI(this.mConnector.getURL());
            URI fetchedURI = new URI(this.mFetchOptions.getUri());
            UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.mFetchOptions.getUri());
            builder.replacePath(dsURI.getPath() + fetchedURI.getPath());
            builder.scheme(dsURI.getScheme());
            builder.host(dsURI.getHost());
            config.setUrl(URLDecoder.decode(builder.build().toUriString(), StandardCharsets.UTF_8.toString()));
        }
        catch (Exception e) {
            throw new GadgetBadConfigException("Problems with the gadget configuration", e);
        }
        config.setMethod(Request.MethodType.GET);
        if (this.mFetchOptions.getOptions().getMethod() != null) {
            config.setMethod(Request.MethodType.valueOf((String)this.mFetchOptions.getOptions().getMethod()));
        }
        HashMap<String, String> headers = new HashMap<String, String>(this.dsHeaders);
        config.setHeaders(headers);
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        if (this.mFetchOptions.getOptions().getHeaders() != null) {
            this.mFetchOptions.getOptions().getHeaders().forEach((key, value) -> {
                if (value != null && !value.isEmpty()) {
                    headers.put((String)key, (String)value);
                }
            });
        }
        if (this.mFetchOptions.getOptions().getBody() != null && !this.mFetchOptions.getOptions().getBody().isEmpty()) {
            config.setBody(this.mFetchOptions.getOptions().getBody());
        }
        config.setParams(this.dsParams);
        ResponseEntity response = this.mConnector.executeRequest(config);
        ResponseChecker.checkStatusWithDhUserErrorHandler(response, "FAILED_REQUEST");
        return response.getBody();
    }
}

