/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters;

import com.roninpixels.dashboardhub.controllers.gadgets.GadgetsRequesterController;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.SecureGadgetDefProviderSrv;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.CustomReportsGadgetRequestModel;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.FetchOptions;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.Options;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomReportsGadgetRequestService {
    private static final Logger log = LoggerFactory.getLogger(CustomReportsGadgetRequestService.class);
    @Inject
    private GadgetsRequesterController controller;
    @Inject
    private DashboardHubPluginManager dhLicenseManager;
    @Inject
    private SecureGadgetDefProviderSrv securityCheckerSrv;
    @Inject
    private DatasourcesUtil dsUtils;

    void validateFetchOptions(FetchOptions fetchOptions, List<String> allowedMethods) throws GadgetRequesterException {
        if (fetchOptions == null) {
            throw new GadgetRequesterException("FetchOptions must be provided", 400);
        }
        Options options = fetchOptions.getOptions();
        this.validateHttpMethod(options, allowedMethods);
    }

    private void validateHttpMethod(Options options, List<String> allowedMethods) throws GadgetRequesterException {
        String method;
        String string = method = options != null && options.getMethod() != null ? options.getMethod().toUpperCase() : "GET";
        if (allowedMethods == null || allowedMethods.isEmpty()) {
            if (!"GET".equals(method)) {
                throw new GadgetRequesterException(String.format("Method not allowed: %s. Only GET is allowed by default.", method), 400);
            }
            return;
        }
        if (!allowedMethods.contains(method)) {
            throw new GadgetRequesterException(String.format("Method not allowed: %s. Allowed methods are: %s", method, String.join((CharSequence)", ", allowedMethods)), 400);
        }
    }

    private List<String> getAllowedDatasourceMethods(DsOptionsModel dsOptions) {
        if (dsOptions == null || dsOptions.getOtherConfig() == null) {
            return Collections.singletonList("GET");
        }
        Map options = dsOptions.getOtherConfig().getOrDefault("options", Collections.emptyMap());
        String allowedMethodsStr = options.getOrDefault("methods", "GET").toUpperCase().replaceAll("\\s+", "");
        List<String> allowedMethodsList = allowedMethodsStr.isEmpty() ? Collections.singletonList("GET") : Arrays.stream(allowedMethodsStr.split(",")).filter(method -> !method.isEmpty()).collect(Collectors.toList());
        return allowedMethodsList;
    }

    public Response doRequest(CustomReportsGadgetRequestModel gadgetRequest) {
        try {
            GadgetModel gadget = this.securityCheckerSrv.checkAndGetStoredGadget(gadgetRequest);
            Map<String, FetchOptions> context = Collections.singletonMap("fetchOptions", gadgetRequest.getFetchOptions());
            return this.doRequest(gadget, gadgetRequest.getExtraParams(), context);
        }
        catch (GadgetRequesterException gre) {
            log.error("Problems with gadget request", (Throwable)gre);
            return ResponseBuilder.createErrorFrom(gre);
        }
    }

    public Response doRequest(GadgetModel gadget, List<String> extraParams, Map context) {
        try {
            if (gadget == null) {
                throw new GadgetRequesterException("INVALID_GADGET", 400);
            }
            if (!this.dhLicenseManager.isLicensed()) {
                throw new GadgetRequesterException("License is not valid", 400);
            }
            DsOptionsModel dsOptions = this.dsUtils.getSecretOptions(gadget.getConfig().getDatasource().getToken());
            List<String> allowedMethodsList = this.getAllowedDatasourceMethods(dsOptions);
            FetchOptions fetchOptions = (FetchOptions)context.get("fetchOptions");
            this.validateFetchOptions(fetchOptions, allowedMethodsList);
            Object data = this.controller.getDataFor(gadget, gadget.getConfig().getDatasource(), extraParams, context);
            return ResponseBuilder.ok(data).build();
        }
        catch (DhUserException due) {
            return ResponseBuilder.createErrorResponseFrom(due);
        }
        catch (BadRequestToSourceException bre) {
            log.error("Request problems for a gadget request");
            return ResponseBuilder.createErrorFrom(bre);
        }
        catch (GadgetRequesterException gre) {
            log.error("Problems with gadget request", (Throwable)gre);
            return ResponseBuilder.createErrorFrom(gre);
        }
        catch (Exception e) {
            log.error("Problems with gadget request", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

