/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.datasources.generators.DsGeneratorBase;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="JiraConfBitbucketCloud")
public class JiraConfBitbucketCloud
extends DsGeneratorBase {
    private static final Logger log = LoggerFactory.getLogger(JiraConfBitbucketCloud.class);
    @Inject
    private Crypto mCrypto;
    @Inject
    private ConnectorsFactory connectorsFactory;
    @Inject
    private DHObjectMapper mapper;
    private static final List<String> PRODUCTS = Arrays.asList(Product.JIRA.value(), Product.CONFLUENCE.value(), Product.BITBUCKET.value());

    @Override
    public boolean match(DatasourceModel def) {
        DsOptionsModel options = def.getOptions();
        boolean isDatacenter = false;
        if (options != null) {
            Object datacenterOption = options.getOtherConfig().get(ProductHosting.DATACENTER.value());
            boolean bl = isDatacenter = datacenterOption != null && Boolean.TRUE.equals(datacenterOption);
            if (!isDatacenter) {
                String hostType = options.getOption("hostType", String.class);
                Boolean datacenter = hostType != null && ProductHosting.DATACENTER.value().equals(hostType);
                isDatacenter = datacenter != null && datacenter != false;
            }
        }
        return !isDatacenter && PRODUCTS.contains(def.getProduct());
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        DatasourceModel newDs = this.generateBasicInfoFrom(dsDef);
        newDs.setType(ProductHosting.CLOUD.value());
        DsOptionsModel tokenData = this.generateDsOptions(newDs, options);
        String token = this.mCrypto.encryptBackend(this.mapper.writeValueAsString(tokenData));
        newDs.setToken(token);
        this.validate(newDs, datasources);
        return newDs;
    }

    DsOptionsModel generateDsOptions(DatasourceModel ds, DsOptionsModel options) {
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", ds.getId());
        tokenData.addOtherConfig("url", ds.getUrl());
        tokenData.addOtherConfig("options", options);
        tokenData.addOtherConfig("hostType", ds.getType());
        tokenData.addOtherConfig(ds.getType(), true);
        return tokenData;
    }

    @Override
    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
        super.validate(dsDef, datasources);
        try {
            DHConnector connector = this.connectorsFactory.getConnector(dsDef);
            if (!connector.isValid()) {
                throw new DhUserException(400, "INVALID_INSTANCE", "Generic error when the data source validation fails");
            }
        }
        catch (DhUserException bde) {
            throw bde;
        }
        catch (BadRequestToSourceException bre) {
            throw new DhUserException("INVALID_INSTANCE", "error", bre.getResponseEntity());
        }
        catch (Exception e) {
            log.error("Generic invalid data source exception", (Throwable)e);
            throw new DhUserException(400, "INVALID_INSTANCE", e.getMessage());
        }
    }
}

