/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl.restrictions;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.config.frontedModel.GenericRestrictionSettingsModel;
import com.roninpixels.dashboardhub.controllers.DHPermissionController;
import java.util.List;
import javax.inject.Inject;

public abstract class GenericRestrictionsBaseController {
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    @Inject
    @ComponentImport
    private TransactionTemplate transactionTemplate;
    @Inject
    private DHPermissionController permissionController;

    public abstract String getRestrictionPropertyName();

    public abstract String getPermissionTargetId();

    public abstract int getPermissionId();

    protected GenericRestrictionSettingsModel _updateConfig(GenericRestrictionSettingsModel newConfig) {
        String propNameRestricted = this.getRestrictionPropertyName();
        String permissionTargetId = this.getPermissionTargetId();
        int permissionId = this.getPermissionId();
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put(propNameRestricted, (Object)newConfig.getRestricted().toString());
        if (newConfig.getRestricted().booleanValue()) {
            List<String> usersGroups = newConfig.getAllowedUsersGroups();
            this.permissionController.updateConfig(usersGroups, permissionId, permissionTargetId);
        } else {
            this.permissionController.deletePermissions(permissionId, permissionTargetId);
        }
        return this._getConfig();
    }

    public GenericRestrictionSettingsModel updateSettings(GenericRestrictionSettingsModel newConfig) {
        return (GenericRestrictionSettingsModel)this.transactionTemplate.execute(() -> this._updateConfig(newConfig));
    }

    protected GenericRestrictionSettingsModel _getConfig() {
        String propNameRestricted = this.getRestrictionPropertyName();
        String permissionTargetId = this.getPermissionTargetId();
        int permissionId = this.getPermissionId();
        GenericRestrictionSettingsModel config = new GenericRestrictionSettingsModel();
        config.setRestricted(this.isActionRestricted());
        if (config.getRestricted().booleanValue()) {
            List<String> groupsAndUsers = this.permissionController.getUsersAndGroups(permissionId, permissionTargetId);
            config.setAllowedUsersGroups(groupsAndUsers);
        }
        return config;
    }

    public GenericRestrictionSettingsModel getSettings() {
        return (GenericRestrictionSettingsModel)this.transactionTemplate.execute(() -> this._getConfig());
    }

    protected boolean isActionRestricted() {
        String propNameRestricted = this.getRestrictionPropertyName();
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        String restrictedStr = (String)settings.get(propNameRestricted);
        return restrictedStr != null && Boolean.parseBoolean(restrictedStr);
    }

    protected boolean canUserDoAction(String userKey) {
        int permissionId = this.getPermissionId();
        return !this.isActionRestricted() || this.permissionController.isUserAllowedFor(userKey, permissionId);
    }
}

