/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.roninpixels.dashboardhub.controllers.DatasourcePermissionsController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.ProjectService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.store.DHPermissionsRepository;
import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.PermissionModel;
import com.roninpixels.dashboardhub.web.models.RestrictionsModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class DatasourcePermissionsControllerImpl
implements DatasourcePermissionsController {
    @Inject
    private DHPermissionsRepository permissionsRepo;
    @Inject
    private DHUserService userService;
    @Inject
    private DatasourcesController dsController;
    @Inject
    private ProjectService projectService;

    public static List<PermissionModel> getPermissionFrom(DatasourceModel ds) {
        RestrictionsModel restrictions = ds.getRestrictions();
        if (restrictions == null || restrictions.getUserGroups() == null) {
            return Collections.emptyList();
        }
        Map<String, List<String>> groupUsersAndProjects = RestrictionsUtil.breakDownUsersGroupsProjects(restrictions);
        return groupUsersAndProjects.entrySet().parallelStream().flatMap(entry -> ((List)entry.getValue()).stream().map(holderId -> {
            String holderType = RestrictionsUtil.getHolderType((String)entry.getKey());
            PermissionModel permission = new PermissionModel();
            permission.setHolderId((String)holderId);
            permission.setHolderType(holderType);
            permission.setPermission(103);
            permission.setTargetId(ds.getId());
            permission.setTargetType("plugin");
            return permission;
        })).collect(Collectors.toList());
    }

    @Override
    public boolean isUserAllowedToUse(DatasourceModel ds, String userKey) {
        if (userKey == null) {
            return false;
        }
        if (ds.getCreator().equals(userKey)) {
            return true;
        }
        if (ds.getRestrictions() != null && (ds.getRestrictions().getType().equals("anyUseEdit") || ds.getRestrictions().getType().equals("anyUseSomeEdit"))) {
            return true;
        }
        List<String> accesibleDsIds = this.getAccesibleDatasourceIds(userKey);
        return accesibleDsIds.stream().anyMatch(id -> ds.getId().equals(id));
    }

    @Override
    public boolean isLoggedInUserAllowedToUse(DatasourceModel ds) {
        return this.isUserAllowedToUse(ds, this.userService.getLoggedInUserKey());
    }

    @Override
    public boolean isLoggedInUserAllowedToUse(String dsId) {
        try {
            DatasourceModel ds = this.dsController.getDatasource(dsId);
            return ds != null && this.isUserAllowedToUse(ds, this.userService.getLoggedInUserKey());
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public List<String> getAccesibleDatasourceIds(String userKey) {
        if (userKey == null) {
            return Collections.emptyList();
        }
        ArrayList<String> groupNames = new ArrayList<String>(this.userService.getGroupNamesFor(userKey));
        return this.getAccesibleDatasourceIds(userKey, groupNames);
    }

    @Override
    public void updateDatasourcePermissions(DatasourceModel ds) {
        this.removeDatasourcePermissions(ds);
        List<PermissionModel> permissions = DatasourcePermissionsControllerImpl.getPermissionFrom(ds);
        if (permissions.isEmpty()) {
            return;
        }
        this.permissionsRepo.createPermissions(permissions);
    }

    @Override
    public void removeDatasourcePermissions(String dsId) {
        this.permissionsRepo.deletePermissions((Integer)103, dsId);
    }

    private void removeDatasourcePermissions(DatasourceModel ds) {
        this.permissionsRepo.deletePermissions((Integer)103, ds.getId());
    }

    private List<String> getAccesibleDatasourceIds(String userKey, List<String> groups) {
        if (userKey == null && (groups == null || groups.isEmpty())) {
            return Collections.emptyList();
        }
        List<String> regularDatasourceIds = this.getRegularDatasourceIds(userKey, groups);
        List<String> projectDatasourceIds = this.getProjectDatasourceIds(userKey);
        List combinedDatasourceIds = Stream.concat(regularDatasourceIds.stream(), projectDatasourceIds.stream()).distinct().collect(Collectors.toList());
        return combinedDatasourceIds.stream().distinct().collect(Collectors.toList());
    }

    private List<String> getRegularDatasourceIds(String userKey, List<String> groups) {
        HashMap<String, List<String>> queryData = new HashMap<String, List<String>>();
        if (userKey != null) {
            queryData.put("user", Arrays.asList(userKey));
        }
        if (groups != null && !groups.isEmpty()) {
            queryData.put("group", groups);
        }
        List<PermissionModel> permissions = this.permissionsRepo.getPermissions((Integer)103, queryData);
        List<String> regularDatasourceIds = permissions.stream().map(PermissionModel::getTargetId).collect(Collectors.toList());
        return regularDatasourceIds;
    }

    private List<String> getProjectDatasourceIds(String userKey) {
        List<PermissionModel> projectPermissions = this.permissionsRepo.getPermissionsByHolderType(103, "project");
        List<String> configuredProjectKeys = projectPermissions.stream().map(PermissionModel::getHolderId).collect(Collectors.toList());
        Collection<Map> userAccessibleProjects = this.projectService.getProjectsFor(userKey, configuredProjectKeys);
        List accessibleProjectKeys = userAccessibleProjects.stream().map(project -> (String)project.get("key")).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> projectDatasourceIds = projectPermissions.stream().filter(permission -> accessibleProjectKeys.contains(permission.getHolderId())).map(PermissionModel::getTargetId).collect(Collectors.toList());
        return projectDatasourceIds;
    }
}

