/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.ApproxCountResponse;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.ResponseEntity;

public class AsyncRequest {
    static final String PATH_SEARCH = "/rest/api/3/search/jql";
    static final String PATH_COUNT = "/rest/api/3/search/approximate-count";

    public static <T> CompletableFuture<T> postChecked(ServerConnector connector, String path, Map<String, Object> params, Class<T> clazz) {
        return CompletableFuture.supplyAsync(() -> {
            ResponseEntity response = connector.executeRequest(Request.MethodType.POST, path, params, clazz);
            ResponseChecker.checkStatus(response);
            return response.getBody();
        });
    }

    public static CompletableFuture<ApproxCountResponse> approxCount(ServerConnector connector, String jql) {
        return AsyncRequest.postChecked(connector, PATH_COUNT, Collections.singletonMap("jql", JqlUtils.sanitizeJql(jql)), ApproxCountResponse.class);
    }

    public static CompletableFuture<JQLResponse> search(ServerConnector connector, Map<String, Object> params) {
        return AsyncRequest.postChecked(connector, PATH_SEARCH, params, JQLResponse.class);
    }
}

