/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.confluence.server.ConfluenceRestConnector;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class IsValidCloudFunc {
    private static final Logger log = LoggerFactory.getLogger(IsValidCloudFunc.class);
    private final ConfluenceRestConnector confConnector;
    private final ServerConnector connector;
    private DHObjectMapper mapper = new DHObjectMapperImpl();

    public IsValidCloudFunc(ConfluenceRestConnector confConnector, ServerConnector connector) {
        this.confConnector = confConnector;
        this.connector = connector;
    }

    public boolean isValid() {
        try {
            ResponseEntity<String> response = this.confConnector.me();
            log.debug("SERVER INFO");
            log.debug("-----------status code", (Object)response.getStatusCode());
            log.debug("------------------body", response.getBody());
            if (response.getStatusCode().value() >= 400) {
                return false;
            }
            Map data = this.mapper.readValue((String)response.getBody(), Map.class);
            log.debug("------------------buildNumber", data.get("buildNumber"));
            int buildNumber = (Integer)data.get("buildNumber");
            return buildNumber >= 7901;
        }
        catch (Exception e) {
            log.error("Problems getting server info. URL base: " + this.confConnector.getURL(), (Throwable)e);
            return false;
        }
    }
}

