/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.BitbucketCountResultsFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.GetCommitFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.GetDeploymentsFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.GetPipelineStepsFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.GetPrInfoFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.GetPrsFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.GetPullRequestsFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.GetRepositoriesFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.GetWorkspacesFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.BitbucketConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class BitbucketCloudConnectorImpl
implements BitbucketConnector {
    private static final Logger log = LoggerFactory.getLogger(BitbucketCloudConnectorImpl.class);
    private ServerConnector connector;

    public BitbucketCloudConnectorImpl(ServerConnector connector) {
        this.connector = connector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public String getProjectFromDs() {
        return null;
    }

    @Override
    public boolean isValid() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putIfAbsent("pagelen", "1");
        ResponseEntity<List> repos = this.getRepositories(null, params, false);
        ResponseChecker.checkStatus(repos);
        return true;
    }

    public String getWorkspace() {
        return this.connector.getProperty("workspaceId", String.class);
    }

    @Override
    public ResponseEntity<Map> getUser(String workspace, String accountId) {
        String path = "/2.0/workspaces/%s/members/%s";
        return this.connector.executeRequest(String.format(path, workspace, accountId), Collections.emptyMap(), Map.class);
    }

    @Override
    public ResponseEntity<List> getWorkspaceMembers() {
        String path = String.format("/2.0/workspaces/%s/members", this.getWorkspace());
        ResponseEntity<Map> res = this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
        return res.getStatusCodeValue() < 400 ? new ResponseEntity((Object)((List)((Map)res.getBody()).get("values")), res.getStatusCode()) : new ResponseEntity(res.getStatusCode());
    }

    @Override
    public ResponseEntity<Integer> countWorkspaceMembers() {
        String path = String.format("/2.0/workspaces/%s/members", this.getWorkspace());
        return new BitbucketCountResultsFunc(this.connector).exec(path, Collections.emptyMap());
    }

    @Override
    public ResponseEntity<List> getRepositories(String project, Map<String, String> params, boolean loadAll) {
        return new GetRepositoriesFunc(this.connector, this.getWorkspace()).exec(params, loadAll);
    }

    @Override
    public ResponseEntity<List> searchRepositories(Map<String, String> params, boolean loadAll) {
        if (params.containsKey("limit")) {
            params.put("pagelen", params.remove("limit"));
        }
        if (params.containsKey("name")) {
            params.put("q", "name ~ \"" + params.remove("name") + "\"");
        } else if (params.containsKey("slug")) {
            params.put("q", "slug = \"" + params.remove("slug") + "\"");
            params.remove("project");
        }
        return this.getRepositories(null, params, loadAll);
    }

    @Override
    public ResponseEntity<Map> getRepository(String project, String repoSlug) {
        String path = String.format("/2.0/repositories/%s/%s", this.getWorkspace(), repoSlug);
        return this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
    }

    @Override
    public ResponseEntity<List> getPrs(String project, String repoSlug) {
        return new GetPrsFunc(this.connector, this.getWorkspace()).exec(repoSlug);
    }

    @Override
    public ResponseEntity<Map> getPrInfo(Map pullRequest, List<String> expand) {
        return new GetPrInfoFunc(this.connector, this.getWorkspace()).exec(pullRequest, expand);
    }

    @Override
    public ResponseEntity<List> getPullRequests(String project, String repoSlug, Map<String, String> params, boolean loadAll) {
        return new GetPullRequestsFunc(this.connector, this.getWorkspace()).exec(repoSlug, params, loadAll);
    }

    @Override
    public ResponseEntity<Integer> countPullRequests(String project, String repoSlug, Map<String, String> params) {
        String path = String.format("/2.0/repositories/%s/%s/pullrequests", this.getWorkspace(), repoSlug);
        return new BitbucketCountResultsFunc(this.connector).exec(path, params);
    }

    @Override
    public ResponseEntity<Map> getCommit(String project, String repoSlug, String hash) {
        return new GetCommitFunc(this.connector, this.getWorkspace()).exec(repoSlug, hash);
    }

    @Override
    public ResponseEntity<List> getPipelines(String repoSlug, Map<String, String> params) {
        String path = String.format("/2.0/repositories/%s/%s/pipelines/", this.getWorkspace(), repoSlug);
        ResponseEntity<Map> res = this.connector.executeRequest(path, params, Map.class);
        if (res.getStatusCodeValue() < 400) {
            List pipelines = (List)((Map)res.getBody()).get("values");
            return new ResponseEntity((Object)pipelines, res.getStatusCode());
        }
        throw new BadRequestToSourceException(res);
    }

    @Override
    public ResponseEntity<Map> getPipeline(String repoSlug, String pipelineUuid) {
        String path = String.format("/2.0/repositories/%s/%s/pipelines/%s", this.getWorkspace(), repoSlug, pipelineUuid);
        return this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
    }

    @Override
    public ResponseEntity<List> getPipelineSteps(String repoSlug, String pipelineUuid, Map<String, String> options) {
        return new GetPipelineStepsFunc(this.connector, this.getWorkspace()).exec(repoSlug, pipelineUuid, options);
    }

    @Override
    public ResponseEntity<List> getDeployments(String repoSlug, Map<String, String> options, boolean loadAll) {
        return new GetDeploymentsFunc(this.connector, this.getWorkspace()).exec(repoSlug, options, loadAll);
    }

    @Override
    public ResponseEntity<Map> getDeployment(String repoSlug, String deploymentUuid) {
        String path = String.format("/2.0/repositories/%s/%s/deployments/%s", this.getWorkspace(), repoSlug, deploymentUuid);
        return this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
    }

    @Override
    public ResponseEntity<Map> getEnvironment(String repoSlug, String environmentUuid) {
        String path = String.format("/2.0/repositories/%s/%s/environments/%s", this.getWorkspace(), repoSlug, environmentUuid);
        return this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
    }

    @Override
    public ResponseEntity<List> getWorkspaces(Map<String, String> params, boolean loadAll) {
        return new GetWorkspacesFunc(this.connector).exec(params, loadAll);
    }

    @Override
    public ResponseEntity<List> getProjects(Map<String, String> params, boolean loadAll) {
        throw new RuntimeException("Method 'getProjects()' is not supported by BitbucketCloudConnector");
    }

    @Override
    public ResponseEntity<String> getPipelineStepLog(String repoSlug, String pipelineUuid, String stepUuid) {
        String path = String.format("/2.0/repositories/%s/%s/pipelines/%s/steps/%s/log", this.getWorkspace(), repoSlug, pipelineUuid, stepUuid);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*");
        return this.connector.executeRequest(Request.MethodType.GET, path, Collections.emptyMap(), headers, String.class);
    }
}

