/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.authStrategy.strategies;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.TrustedRequest;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.StrategyWithHeaders;
import com.roninpixels.dashboardhub.controllers.DatasourceRunAsOwnerSettingsController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class SelfAuthenticatorStrategy
extends StrategyWithHeaders {
    private static final Logger log = LoggerFactory.getLogger(SelfAuthenticatorStrategy.class);
    private final DatasourceModel datasource;
    private final String SYSTEM_USER_TOKEN = "dh-addon-system";
    private AppUser loggedInUser;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private DatasourceRunAsOwnerSettingsController datasourceRunAsOwnerSettingsController;

    public SelfAuthenticatorStrategy(DatasourceModel datasource) {
        this.datasource = datasource;
    }

    @PostConstruct
    public void init() {
        this.loggedInUser = this.dhUserService.getLoggedInUser();
    }

    private AppUser getUser() {
        String ownerKey = this.datasource.getCreator();
        AppUser user = ownerKey == null || "dh-addon-system".equals(ownerKey) || this.datasourceRunAsOwnerSettingsController.isRunAsOwnerRestricted() || this.datasource.getOptions() != null && "viewer".equals(this.datasource.getOptions().getOption("runAs")) ? this.loggedInUser : this.dhUserService.getUserByKey(ownerKey);
        return user;
    }

    @Override
    public Request applyAuthenticationStrategy(Request request, UriComponentsBuilder builder) {
        super.applyAuthenticationStrategy(request, builder);
        log.debug("Jira self authentication  ----------- creator ------ " + this.datasource.getCreator());
        AppUser user = this.getUser();
        log.debug("----user--- " + user);
        return ((TrustedRequest)request).addTrustedTokenAuthentication(builder.build().getHost(), user.getName());
    }
}

