/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.app.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.roninpixels.dashboardhub.services.DHWhitelistService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class DHWhiteListServiceImpl
implements DHWhitelistService {
    private static final List<String> ALLOWED_HOSTS = Arrays.asList("127.0.0.1", "localhost");
    @Inject
    @ComponentImport
    private WhitelistService whitelistService;
    @Inject
    @ComponentImport
    private OutboundWhitelist outboundWhitelist;

    @Override
    public boolean isAllowed(String uri) {
        try {
            URI _uri = new URI(uri);
            return !this.whitelistService.isWhitelistEnabled() || ALLOWED_HOSTS.contains(_uri.getHost()) || this.outboundWhitelist.isAllowed(_uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }
}

