/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.analytics;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboards.analytics.amplitude.AnalyticsInfoProvider;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
class DefaultAnalyticsProvider
implements AnalyticsInfoProvider {
    @Inject
    private PluginLicenseManager licenseManager;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private ApplicationPropertiesAccesor dhPropertiesAccesor;

    DefaultAnalyticsProvider() {
    }

    @Override
    public String getServerId() {
        return this.licenseManager.getLicense().isDefined() ? ((PluginLicense)this.licenseManager.getLicense().get()).getServerId() : "";
    }

    @Override
    public String getHostBaseURL() {
        return this.dhPropertiesAccesor.getAppProperty("baseURL", "");
    }

    @Override
    public String getHostProduct() {
        return this.dhPropertiesAccesor.getApplicationName();
    }

    @Override
    public String getUserId() {
        AppUser user = this.dhUserService.getLoggedInUser();
        return user == null ? null : user.getKey();
    }

    @Override
    public String getLicenseType() {
        return this.licenseManager.getLicense().isDefined() ? ((PluginLicense)this.licenseManager.getLicense().get()).getLicenseTypeDescriptionKey() : null;
    }
}

