/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.analytics;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.roninpixels.dashboardhub.analytics.AnalyticsConfigSrv;
import com.roninpixels.dashboardhub.controllers.FeatureManagementController;
import com.roninpixels.dashboardhub.license.rulesImpl.DEVModeRule;
import com.roninpixels.dashboards.analytics.amplitude.AnalyticsService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsConfigSrvImpl
implements AnalyticsConfigSrv {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsConfigSrvImpl.class);
    public static final String CONFIG_FILE_NAME = "analytics_config.properties";
    public static final String DEV_CONFIG_FILE_NAME = "analytics_config_dev.properties";
    public static final String PROP_AMPLITUDE_KEY = "AMPLITUDE_API_KEY";
    @Inject
    @ComponentImport
    private HostLicenseInformation hostLicenseInformation;
    @Inject
    private FeatureManagementController featureManagementController;
    @Inject
    private AnalyticsService analyticsService;
    private Properties mProps;

    @Inject
    public AnalyticsConfigSrvImpl(DEVModeRule devModeRule) {
        this.init(devModeRule);
    }

    private void init(DEVModeRule devModeRule) {
        String resource = devModeRule.isDevModeEnabled() ? DEV_CONFIG_FILE_NAME : CONFIG_FILE_NAME;
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(resource);){
            if (input == null) {
                log.error("Analytics config file not found -> " + resource);
                return;
            }
            this.mProps = new Properties();
            this.mProps.load(input);
        }
        catch (IOException ex) {
            log.error("Problems loading the analytics config file", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    @Override
    public String getAmplitudeKey() {
        return this.mProps == null || !this.featureManagementController.isAnalytics() ? null : (String)this.mProps.get(PROP_AMPLITUDE_KEY);
    }

    @Override
    public String getHashedUserId() {
        return this.analyticsService.getHashedUserId();
    }
}

