/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub;

import com.roninpixels.dashboardhub.controllers.UserPreferencesController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.UserPreferencesModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserPreferencesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(UserPreferencesEndpoint.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private UserPreferencesController userPreferencesCtr;
    @Inject
    private DHObjectMapper mapper;

    public Response getUserPreferences() {
        String userKey = this.dhUserService.getLoggedInUserKey();
        UserPreferencesModel prefs = this.userPreferencesCtr.getUserPreference(userKey);
        return ResponseBuilder.ok(prefs).build();
    }

    public Response setUserPreferences(String rawPrefs) {
        String userKey = this.dhUserService.getLoggedInUserKey();
        try {
            UserPreferencesModel prefs = this.mapper.readValue(rawPrefs, UserPreferencesModel.class);
            UserPreferencesModel savedPrefs = this.userPreferencesCtr.createOrUpdateUserPreference(userKey, prefs);
            return ResponseBuilder.ok(savedPrefs).build();
        }
        catch (Exception e) {
            log.error("Problems saving the preferences of a user - " + userKey, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

