/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.customReports;

import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.gadgetsRequesters.CustomReportsGadgetRequestService;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.SecureGadgetDefProviderSrv;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.CustomReportsGadgetRequestModel;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customReports.FetchOptions;
import com.roninpixels.dashboardhub.services.DHSessionService;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/board/memory/customReportGadget")
public class MemoryCRGadgetRequesterEndpoint {
    private static final Logger log = LoggerFactory.getLogger(MemoryCRGadgetRequesterEndpoint.class);
    @Inject
    private CustomReportsGadgetRequestService crGadgetRequestService;
    @Inject
    private DHObjectMapper mapper;
    @Inject
    private DHSessionService dhSessionService;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private SecureGadgetDefProviderSrv grSecurityCheckerSrv;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doRequest(String gadgetRequestRaw) {
        CustomReportsGadgetRequestModel gadgetRequest = null;
        try {
            gadgetRequest = this.mapper.readValue(gadgetRequestRaw, CustomReportsGadgetRequestModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        GadgetModel gadget = null;
        try {
            gadget = this.grSecurityCheckerSrv.checkAndGetGadgetByRequest(gadgetRequest);
        }
        catch (GadgetRequesterException e) {
            log.error("Problems getting the gadget related to the ", (Throwable)e);
            return ResponseBuilder.createErrorFrom(e);
        }
        catch (DhUserException due) {
            log.debug("Problems getting the gadget related to a DHUserException ", (Throwable)due);
            return ResponseBuilder.createErrorResponseFrom(due);
        }
        Map<String, FetchOptions> context = Collections.singletonMap("fetchOptions", gadgetRequest.getFetchOptions());
        return this.crGadgetRequestService.doRequest(gadget, gadgetRequest.getExtraParams(), context);
    }
}

