/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.permissions.rules;

import com.roninpixels.dashboardhub.permissions.EditPermission;
import com.roninpixels.dashboardhub.permissions.UsePermission;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.ProjectService;
import com.roninpixels.dashboardhub.utils.permissions.BoardRestrictionsConfig;
import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.models.RestrictionModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="someUseSomeEdit_PROJECTS")
public class SomeCanEditUseForProjectsRule
implements UsePermission,
EditPermission {
    public static final String PERMISSION_TYPE = "someUseSomeEdit_PROJECTS";
    @Inject
    private DHUserService dhUserService;
    @Inject
    private ProjectService projectService;

    @Override
    public boolean evaluateUse(RestrictionModel restrictionModel) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        BoardRestrictionsConfig config = RestrictionsUtil.getRestrictionsConfig(restrictionModel.getRestrictions());
        List<String> canUseByProjectsKeysConfigured = config.getCanUseProjects();
        Collection<Map> canUseByProjects = this.projectService.getProjectsFor(currentUser, canUseByProjectsKeysConfigured);
        return !canUseByProjects.isEmpty() || this.evaluateEdit(restrictionModel);
    }

    @Override
    public boolean evaluateEdit(RestrictionModel restrictionModel) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        BoardRestrictionsConfig config = RestrictionsUtil.getRestrictionsConfig(restrictionModel.getRestrictions());
        List<String> canEditByProjectsKeysConfigured = config.getCanEditProjects();
        Collection<Map> canEditByProjects = this.projectService.getProjectsFor(currentUser, canEditByProjectsKeysConfigured);
        return !canEditByProjects.isEmpty();
    }
}

