/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.permissions.rules;

import com.roninpixels.dashboardhub.permissions.EditPermission;
import com.roninpixels.dashboardhub.permissions.UsePermission;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.models.RestrictionModel;
import com.roninpixels.dashboardhub.web.models.RestrictionsModel;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="anyUseEdit")
public class AnyoneCanEditUseRule
implements UsePermission,
EditPermission {
    public static final String PERMISSION_TYPE = "anyUseEdit";
    @Inject
    private DHUserService dhUserService;

    @Override
    public boolean evaluateUse(RestrictionModel restrictionModel) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        RestrictionsModel restrictions = restrictionModel.getRestrictions();
        return restrictions == null || PERMISSION_TYPE.equals(restrictions.getType());
    }

    @Override
    public boolean evaluateEdit(RestrictionModel restrictionModel) {
        return this.evaluateUse(restrictionModel);
    }
}

