/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.permissions;

import com.roninpixels.dashboardhub.permissions.AccessManager;
import com.roninpixels.dashboardhub.permissions.EditPermission;
import com.roninpixels.dashboardhub.permissions.PermissionRule;
import com.roninpixels.dashboardhub.permissions.UsePermission;
import com.roninpixels.dashboardhub.permissions.ViewPermission;
import com.roninpixels.dashboardhub.web.models.RestrictionModel;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.stereotype.Service;

@Service
public class AccessManagerImpl
implements AccessManager {
    @Inject
    List<ViewPermission> viewRules;
    @Inject
    List<EditPermission> editRules;
    @Inject
    List<UsePermission> useRules;

    private boolean match(RestrictionModel restrictionModel, PermissionRule permissionRule) {
        String type = restrictionModel.getRestrictions() != null ? restrictionModel.getRestrictions().getType() : null;
        String permissionType = permissionRule.getClass().getAnnotation(Named.class).value();
        return type == null || permissionType.startsWith(type);
    }

    @Override
    public boolean canUserLoggedInView(RestrictionModel restrictionModel) {
        return this.viewRules.stream().filter(rule -> this.match(restrictionModel, (PermissionRule)rule)).anyMatch(rule -> rule.evaluateView(restrictionModel));
    }

    @Override
    public boolean canUserLoggedInEdit(RestrictionModel restrictionModel) {
        List rules = this.editRules.stream().filter(rule -> this.match(restrictionModel, (PermissionRule)rule)).collect(Collectors.toList());
        return rules.stream().anyMatch(rule -> rule.evaluateEdit(restrictionModel));
    }

    @Override
    public boolean canUserLoggedInUse(RestrictionModel restrictionModel) {
        return this.useRules.stream().filter(rule -> this.match(restrictionModel, (PermissionRule)rule)).anyMatch(rule -> rule.evaluateUse(restrictionModel));
    }
}

