/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.license;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LicenseStatusJsonBean {
    private boolean isValid;
    private String name;
    private String key;
    private String type;
    private String error;
    private Date expirationTime;
    private String timeBeforeExpiry;

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getTimeBeforeExpiry() {
        return this.timeBeforeExpiry;
    }

    public void setTimeBeforeExpiry(String timeBeforeExpiry) {
        this.timeBeforeExpiry = timeBeforeExpiry;
    }

    public static LicenseStatusJsonBean shortBean(PluginLicense pluginLicense) {
        if (pluginLicense == null) {
            return null;
        }
        LicenseStatusJsonBean bean = new LicenseStatusJsonBean();
        bean.name = pluginLicense.getPluginName();
        bean.key = pluginLicense.getPluginKey();
        bean.type = pluginLicense.getLicenseType().name();
        bean.isValid = pluginLicense.isValid();
        if (!LicenseStatusJsonBean.isUPM6plus()) {
            LicenseStatusJsonBean.populateWithPreviousUPM6(pluginLicense, bean);
        } else {
            LicenseStatusJsonBean.populateWithUPM6plus(pluginLicense, bean);
        }
        bean.error = pluginLicense.getError().isDefined() ? ((LicenseError)pluginLicense.getError().get()).name() : null;
        return bean;
    }

    private static void populateWithPreviousUPM6(PluginLicense pluginLicense, LicenseStatusJsonBean bean) {
        try {
            Object optionExpiryDate = PluginLicense.class.getMethod("getExpiryDate", new Class[0]).invoke((Object)pluginLicense, new Object[0]);
            Class<?> optionClass = optionExpiryDate.getClass();
            if (((Boolean)optionClass.getMethod("isDefined", new Class[0]).invoke(optionExpiryDate, new Object[0])).booleanValue()) {
                Object jodaDateTime = optionClass.getMethod("get", new Class[0]).invoke(optionExpiryDate, new Object[0]);
                Method toDateMethod = jodaDateTime.getClass().getMethod("toDate", new Class[0]);
                bean.expirationTime = (Date)toDateMethod.invoke(jodaDateTime, new Object[0]);
            }
            Object optionTimeBeforeExpiry = PluginLicense.class.getMethod("getTimeBeforeExpiry", new Class[0]).invoke((Object)pluginLicense, new Object[0]);
            if (((Boolean)optionClass.getMethod("isDefined", new Class[0]).invoke(optionTimeBeforeExpiry, new Object[0])).booleanValue()) {
                bean.timeBeforeExpiry = optionClass.getMethod("get", new Class[0]).invoke(optionTimeBeforeExpiry, new Object[0]).toString();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void populateWithUPM6plus(PluginLicense pluginLicense, LicenseStatusJsonBean bean) {
        try {
            Optional optionalDurationBeforeExpiry;
            Optional optionalExpiryZonedDate = (Optional)PluginLicense.class.getMethod("getExpiryZonedDate", new Class[0]).invoke((Object)pluginLicense, new Object[0]);
            if (optionalExpiryZonedDate.isPresent()) {
                bean.expirationTime = Date.from(((ZonedDateTime)optionalExpiryZonedDate.get()).toInstant());
            }
            if ((optionalDurationBeforeExpiry = (Optional)PluginLicense.class.getMethod("getDurationBeforeExpiry", new Class[0]).invoke((Object)pluginLicense, new Object[0])).isPresent()) {
                bean.timeBeforeExpiry = ((Duration)optionalDurationBeforeExpiry.get()).toString();
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isUPM6plus() {
        try {
            return PluginLicense.class.getMethod("getExpiryZonedDate", new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

