/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.AgileGadgetReponseData;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDateUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodOption;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodUtil;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.AgileIssuesProvider;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.BoardsAndSprints;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.JQLAndSprints;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.AgileGadgetConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.ConfigWithGenericFilter;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ProviderBasedOnBoards
extends AgileIssuesProvider {
    private static final Logger log = LoggerFactory.getLogger(ProviderBasedOnBoards.class);

    private Long getDateValue(Map sprint) {
        String date = (String)sprint.get(this.filterDateField);
        return date == null ? Long.MAX_VALUE : JiraDateUtils.getMillisFrom(date);
    }

    protected List<Map> getSprintsByNElements(int lastNElements, List<Map> allSprints) {
        return allSprints.stream().sorted((s1, s2) -> this.getDateValue((Map)s1).compareTo(this.getDateValue((Map)s2))).skip(Math.max(0, allSprints.size() - lastNElements)).collect(Collectors.toList());
    }

    protected List<Map> getSprintsByTimePeriod(int timePeriod, List<Map> allSprints) {
        return allSprints.stream().filter(sprint -> {
            Object rawDate = sprint.get(this.filterDateField);
            return rawDate != null && TimePeriodUtil.matchOptionTimePeriod(TimePeriodOption.getById(timePeriod), (String)rawDate);
        }).collect(Collectors.toList());
    }

    protected List<Map> filterSprints(ConfigWithGenericFilter config, List<Map> allSprints) {
        List<Map> tmpSprints = this.jiraSprintUtils.filterSprintsByState(allSprints, config.getSprintFilter());
        return config.getByTime() != false ? this.getSprintsByTimePeriod(config.getTimePeriod(), tmpSprints) : this.getSprintsByNElements(config.getnElements(), tmpSprints);
    }

    private List<BoardsAndSprints> getBoardsAndSprints(AgileGadgetConfig config) {
        List<BoardsAndSprints> boardsAndSprints = config.getAllBoards().parallelStream().map(boardId -> {
            try {
                ResponseEntity<String> response = this.jiraConnector.getBoardConfiguration((Long)boardId);
                Map boardConfig = ResponseChecker.checkStatusAndParse(response, Map.class);
                List<Map> allSprints = this.jiraSprintUtils.getSprintsWithProjects(this.jiraConnector, (Long)boardId, Collections.emptyMap());
                List<Map> filteredSprints = !(config instanceof ConfigWithGenericFilter) ? allSprints : this.filterSprints(config, allSprints);
                return new BoardsAndSprints(boardConfig, filteredSprints);
            }
            catch (Exception e) {
                log.error("Problem getting the data of the boardId: " + boardId, (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return boardsAndSprints;
    }

    private List<Map> getSprints(List<BoardsAndSprints> boardsAndSprints) {
        return boardsAndSprints.stream().map(BoardsAndSprints::getSprints).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public AgileGadgetReponseData getAgileData(AgileGadgetConfig config, List<String> extraParams) {
        List<BoardsAndSprints> boardsAndSprints = this.getBoardsAndSprints(config);
        List<Map> sprints = this.getSprints(boardsAndSprints);
        List<Map> issues = boardsAndSprints.stream().map(boardSprints -> {
            String filterId = (String)((Map)boardSprints.getBoard().get("filter")).get("id");
            return this.getAgileData(config, extraParams, boardSprints.getSprints(), filterId);
        }).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        AgileGadgetReponseData response = new AgileGadgetReponseData(JiraDataUtils.removeDuplicate(sprints), JiraDataUtils.removeDuplicate(issues));
        response.setSprintField(extraParams.size() > 1 ? extraParams.get(1) : "sprint");
        return response;
    }

    @Override
    public JQLAndSprints getJQLAndSprintsData(AgileGadgetConfig config, List<String> extraParams) {
        List<BoardsAndSprints> boardsAndSprints = this.getBoardsAndSprints(config);
        List<Map> sprints = JiraDataUtils.removeDuplicate(this.getSprints(boardsAndSprints));
        String sprintClause = !extraParams.isEmpty() ? extraParams.get(0) : "Sprint";
        String jql = boardsAndSprints.stream().map(boardSprints -> {
            String filterId = (String)((Map)boardSprints.getBoard().get("filter")).get("id");
            return this.jiraSprintUtils.generateJQL(boardSprints.getSprints(), sprintClause, filterId);
        }).collect(Collectors.joining(" AND "));
        return new JQLAndSprints(sprints, jql);
    }
}

