/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.JQLSearchConfig;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class JQLSearch
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(JQLSearch.class);
    private static final List<String> JQL_EXPAND = Arrays.asList("names", "renderedFields");
    @Inject
    private DHObjectMapper mapper;
    private List<String> myExpand = new LinkedList<String>(JQL_EXPAND);

    public JQLSearch() {
    }

    public JQLSearch(List<String> moreExpandValues) {
        this();
        if (moreExpandValues != null && !moreExpandValues.isEmpty()) {
            this.myExpand.addAll(moreExpandValues);
        }
    }

    String getJQLFrom(JQLSearchConfig config) {
        try {
            long filterId;
            if (config.getFilterId() != null && !"customJQL".equals(config.getFilterId()) && (filterId = Long.parseLong(config.getFilterId())) > 0L) {
                ResponseEntity<Map> response = this.jiraConnector.getFilterById(filterId);
                this.checkStatus(response);
                Map filter = (Map)response.getBody();
                return filter.containsKey("jql") ? (String)filter.get("jql") : null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return config.getJql();
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        JQLSearchConfig config = GadgetRequesterUtils.getConfig(gadget, JQLSearchConfig.class);
        try {
            String jql = this.getJQLFrom(config);
            List<String> requestCalculatedFields = JQLSearch.getCalculatedFields(config);
            List<String> requestFields = this.compileRequestFields(config);
            List<Field> fieldList = this.getFields();
            requestFields.stream().forEach(s -> log.debug(s.getClass().getName()));
            List<String> matchingFields = requestFields.stream().map(f -> JiraDataUtils.getFieldsWithSameName(f, fieldList)).filter(Objects::nonNull).flatMap(fields -> fields.stream()).map(f -> f.getId()).collect(Collectors.toList());
            List<String> extraExpand = this.calculateExtraExpand(fieldList, matchingFields);
            JQLResponse jqlResponse = this.execJQLwithFilterFields(jql, ListUtils.union(matchingFields, requestCalculatedFields), fieldList, Stream.concat(this.myExpand.stream(), extraExpand.stream()).collect(Collectors.toList()), null, null, null);
            List<Map> issues = jqlResponse.getIssues();
            if (!this.jiraConnector.isCloud()) {
                JiraSprintDataUtils.fixSprintField(issues, fieldList);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("total", jqlResponse.getTotal());
            data.put("issues", issues);
            return data;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static List<String> getCalculatedFields(JQLSearchConfig config) {
        List<String> requestCalculatedFields = config.getCalculatedFields().stream().map(calculatedField -> calculatedField.getJiraFieldKeys()).flatMap(Collection::stream).collect(Collectors.toList());
        return requestCalculatedFields;
    }

    private List<String> compileRequestFields(JQLSearchConfig config) {
        List<Object> aggFields = new LinkedList();
        LinkedList<String> requestFields = new LinkedList<String>();
        switch (config.getView()) {
            case "multilinechart": 
            case "stackedbarchart": 
            case "groupedbarchart": 
            case "stackedareachart": 
            case "multipiechart": {
                String chartGroup = this.fieldJQLTransformation(config.getChartGroup());
                requestFields.add(chartGroup);
            }
            case "funnelchart": 
            case "tilechart": 
            case "linechart": 
            case "piechart": 
            case "barchart": 
            case "areachart": {
                String chartBy = this.fieldJQLTransformation(config.getChartBy());
                requestFields.add(chartBy);
                String chartAggregation = this.fieldJQLTransformation(config.getChartAggregation().get(1).toString());
                requestFields.add(chartAggregation);
                break;
            }
            case "pivottable": 
            case "pivottable2d": {
                requestFields.addAll(config.getPivotTables().getRowColumns());
                requestFields.add(config.getPivotTables().getAggregationField());
                if (!config.getView().equals("pivottable2d")) break;
                requestFields.addAll(config.getPivotTables().getColumnColumns());
            }
        }
        if (config.getGroup() && config.getAggregations() != null) {
            aggFields = config.getAggregations().stream().map(agg -> (String)agg.get(1)).filter(field -> !config.getFields().contains(field)).collect(Collectors.toList());
        }
        requestFields = Stream.of(requestFields, config.getFields(), aggFields).flatMap(Collection::stream).map(field -> this.fieldJQLTransformation((String)field)).collect(Collectors.toList());
        return requestFields;
    }

    private String fieldJQLTransformation(String field) {
        return "statusCategory".equals(field) ? "status" : field;
    }
}

