/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.datasources.generators.DsGeneratorBase;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="Opsgenie")
public class OpsgenieRestDs
extends DsGeneratorBase {
    private static final Logger log = LoggerFactory.getLogger(OpsgenieRestDs.class);
    public static final String OPSGENIE_PRODUCT = "opsgenie";
    @Inject
    private Crypto mCrypto;
    @Inject
    private ConnectorsFactory connectorsFactory;
    @Inject
    private DHObjectMapper mapper;

    @Override
    public boolean match(DatasourceModel def) {
        return OPSGENIE_PRODUCT.equals(def.getProduct());
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        try {
            return this.private_generateDS(Boolean.FALSE, dsDef, datasources, options);
        }
        catch (BadRequestToSourceException bre) {
            return this.private_generateDS(Boolean.TRUE, dsDef, datasources, options);
        }
    }

    public DatasourceModel private_generateDS(Boolean isEU, DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options) throws Exception {
        DatasourceModel newDs = this.generateBasicInfoFrom(dsDef);
        newDs.setType("token");
        newDs.setProduct(OPSGENIE_PRODUCT);
        DsOptionsModel tokenData = this.generateDsOptions(newDs, options, isEU);
        String token = this.mCrypto.encryptBackend(this.mapper.writeValueAsString(tokenData));
        newDs.setToken(token);
        this.validate(newDs, datasources);
        return newDs;
    }

    DsOptionsModel generateDsOptions(DatasourceModel ds, DsOptionsModel options, boolean isEU) {
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", ds.getId());
        tokenData.addOtherConfig("name", ds.getName());
        tokenData.addOtherConfig("url", ds.getUrl());
        tokenData.addOtherConfig("product", ds.getProduct());
        tokenData.addOtherConfig("options", options);
        tokenData.addOtherConfig("isEu", isEU);
        return tokenData;
    }

    @Override
    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
        super.validate(dsDef, datasources);
        try {
            DHConnector connector = this.connectorsFactory.getConnector(dsDef);
            if (!connector.isValid()) {
                throw new DhUserException(400, "INVALID_INSTANCE", "Generic error when the data source validation fails");
            }
        }
        catch (DhUserException bde) {
            throw bde;
        }
        catch (BadRequestToSourceException bre) {
            throw new DhUserException("INVALID_INSTANCE", "error", bre.getResponseEntity());
        }
        catch (Exception e) {
            log.error("Generic invalid data source exception", (Throwable)e);
            throw new DhUserException(400, "INVALID_INSTANCE", e.getMessage());
        }
    }
}

