/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.controllers.DashboardGadgetsController;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetTokenController;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetsValidationController;
import com.roninpixels.dashboardhub.gadgetsValidators.GadgetValidatorException;
import com.roninpixels.dashboardhub.gadgetsValidators.ValidationResponse;
import com.roninpixels.dashboardhub.store.DHDashboardGadgetsRepository;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetModel;
import com.roninpixels.dashboardhub.web.models.EncryptedDashboardGadgetModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class DashboardGadgetsControllerImpl
implements DashboardGadgetsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardGadgetsControllerImpl.class);
    @Inject
    private DHDashboardGadgetsRepository dashboardGadgetsRepo;
    @Inject
    private Crypto mCrypto;
    @Inject
    private GadgetTokenController gadgetTokenController;
    @Inject
    private GadgetsValidationController validationController;
    @Inject
    private DHObjectMapper mMapper;

    @Override
    public DashboardGadgetModel getDashboardGadget(String containerId, String itemId) {
        EncryptedDashboardGadgetModel encryptedDashboardGadget = this.dashboardGadgetsRepo.getDashboardGadget(containerId, itemId);
        if (encryptedDashboardGadget == null) {
            return null;
        }
        return this.decryptDashboardGadget(encryptedDashboardGadget);
    }

    @Override
    public DashboardGadgetModel addDashboardGadget(DashboardGadgetModel dashboardGadget) throws Exception {
        this.validateGadget(dashboardGadget);
        this.gadgetTokenController.updateToken(dashboardGadget);
        EncryptedDashboardGadgetModel encrypted = this.generateEncryptedDashboardGadget(dashboardGadget);
        EncryptedDashboardGadgetModel savedEncrypted = this.dashboardGadgetsRepo.addDashboardGadget(encrypted);
        String json = this.mCrypto.decryptBackend(savedEncrypted.getData());
        DashboardGadgetModel newDashboardGadget = this.mMapper.readValue(json, DashboardGadgetModel.class);
        return newDashboardGadget;
    }

    @Override
    public DashboardGadgetModel updateDashboardGadget(DashboardGadgetModel dashboardGadget) throws Exception {
        this.validateGadget(dashboardGadget);
        this.gadgetTokenController.updateToken(dashboardGadget);
        EncryptedDashboardGadgetModel encrypted = this.generateEncryptedDashboardGadget(dashboardGadget);
        EncryptedDashboardGadgetModel savedEncrypted = this.dashboardGadgetsRepo.updateDashboardGadget(encrypted);
        String json = this.mCrypto.decryptBackend(savedEncrypted.getData());
        DashboardGadgetModel updatedDashboardGadget = this.mMapper.readValue(json, DashboardGadgetModel.class);
        return updatedDashboardGadget;
    }

    @Override
    public boolean removeDashboardGadget(String containerId, String itemId) {
        return this.dashboardGadgetsRepo.removeDashboardGadget(containerId, itemId);
    }

    @Override
    public DashboardGadgetModel addDashboardGadget(DashboardGadgetModel dashboardGadget, boolean idAsItemId) throws Exception {
        if (!idAsItemId) {
            return this.addDashboardGadget(dashboardGadget);
        }
        this.validateGadget(dashboardGadget);
        this.gadgetTokenController.updateToken(dashboardGadget);
        EncryptedDashboardGadgetModel encrypted = this.generateEncryptedDashboardGadget(dashboardGadget);
        EncryptedDashboardGadgetModel savedEncrypted = this.dashboardGadgetsRepo.addDashboardGadget(encrypted, true);
        dashboardGadget.setItemId(savedEncrypted.getItemId());
        this.gadgetTokenController.updateToken(dashboardGadget);
        dashboardGadget = this.updateDashboardGadget(dashboardGadget);
        EncryptedDashboardGadgetModel encryptedUpdated = this.generateEncryptedDashboardGadget(dashboardGadget);
        String json = this.mCrypto.decryptBackend(encryptedUpdated.getData());
        DashboardGadgetModel newDashboardGadget = this.mMapper.readValue(json, DashboardGadgetModel.class);
        return newDashboardGadget;
    }

    @Override
    public DashboardGadgetModel decryptDashboardGadget(EncryptedDashboardGadgetModel encryptedDashboardGadget) {
        DashboardGadgetModel result = null;
        if (encryptedDashboardGadget != null) {
            try {
                String json = this.mCrypto.decryptBackend(encryptedDashboardGadget.getData());
                result = this.mMapper.readValue(json, DashboardGadgetModel.class);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Problems with dashboard gadget! containerId: %s, itemId: %s", encryptedDashboardGadget.getContainerId(), encryptedDashboardGadget.getItemId()), (Throwable)e);
            }
        }
        return result;
    }

    private EncryptedDashboardGadgetModel generateEncryptedDashboardGadget(DashboardGadgetModel dashboardGadget) throws Exception {
        EncryptedDashboardGadgetModel encrypted = new EncryptedDashboardGadgetModel();
        encrypted.setContainerId(dashboardGadget.getContainerId());
        encrypted.setItemId(dashboardGadget.getItemId());
        encrypted.setOwner(dashboardGadget.getOwner());
        encrypted.setCreated(dashboardGadget.getCreated());
        encrypted.setUpdated(dashboardGadget.getUpdated());
        String json = this.mMapper.writeValueAsString(dashboardGadget);
        encrypted.setData(this.mCrypto.encryptBackend(json));
        return encrypted;
    }

    private void validateGadget(GadgetModel gadget) throws GadgetValidatorException {
        ValidationResponse validationResponse = this.validationController.validateDataFor(gadget);
        if (!validationResponse.isValid()) {
            LOGGER.error(validationResponse.getError());
            throw new GadgetValidatorException(validationResponse.getError());
        }
    }
}

