/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.controllers.DHPermissionController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.store.DHPermissionsRepository;
import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.models.PermissionModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class DHPermissionControllerImpl
implements DHPermissionController {
    @Inject
    @ComponentImport
    private TransactionTemplate transactionTemplate;
    @Inject
    private DHPermissionsRepository permissionsRepo;
    @Inject
    private DHUserService userService;

    public static final List<PermissionModel> getPermissionsFrom(List<String> userGroupList, int pPermission, String permissionTarget) {
        Map<String, List<String>> groupAndUsers = RestrictionsUtil.breakDownUsersGroupsProjects(userGroupList);
        return groupAndUsers.entrySet().parallelStream().flatMap(entry -> ((List)entry.getValue()).stream().map(holderId -> {
            String holderType = ((String)entry.getKey()).contains("user") ? "user" : "group";
            PermissionModel permission = new PermissionModel();
            permission.setHolderId((String)holderId);
            permission.setHolderType(holderType);
            permission.setPermission(pPermission);
            permission.setTargetId(permissionTarget);
            permission.setTargetType("plugin");
            return permission;
        })).collect(Collectors.toList());
    }

    @Override
    public void updateConfig(final List<String> usersGroups, final int permission, final String permissionTarget) {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                DHPermissionControllerImpl.this.permissionsRepo.deletePermissions((Integer)permission, permissionTarget);
                if (usersGroups != null && !usersGroups.isEmpty()) {
                    List<PermissionModel> permissions = DHPermissionControllerImpl.getPermissionsFrom(usersGroups, permission, permissionTarget);
                    DHPermissionControllerImpl.this.permissionsRepo.createPermissions(permissions);
                }
                return null;
            }
        });
    }

    @Override
    public void deletePermissions(int permission, String permissionTarget) {
        this.permissionsRepo.deletePermissions((Integer)permission, permissionTarget);
    }

    @Override
    public List<String> getUsersAndGroups(final int permission, final String permissionTarget) {
        return (List)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                List<PermissionModel> storedPermissions = DHPermissionControllerImpl.this.permissionsRepo.getPermissions((Integer)permission, permissionTarget);
                List groupsAndUsers = storedPermissions.stream().map(p -> String.format("%sId:%s", p.getHolderType(), p.getHolderId())).collect(Collectors.toList());
                return groupsAndUsers;
            }
        });
    }

    @Override
    public boolean isUserAllowedFor(String userKey, int permissionTarget) {
        if (userKey == null) {
            return false;
        }
        HashMap<String, List<String>> queryData = new HashMap<String, List<String>>();
        queryData.put("user", Arrays.asList(userKey));
        ArrayList<String> groupNames = new ArrayList<String>(this.userService.getGroupNamesFor(userKey));
        queryData.put("group", groupNames);
        List<PermissionModel> permissions = this.permissionsRepo.getPermissions((Integer)permissionTarget, queryData);
        return !permissions.isEmpty();
    }
}

