/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.controllers.DHPermissionController;
import com.roninpixels.dashboardhub.controllers.DatasourceRunAsOwnerSettingsController;
import com.roninpixels.dashboardhub.controllers.DatasourceSettingsController;
import com.roninpixels.dashboardhub.controllers.DatasourceSharingSettingsController;
import com.roninpixels.dashboardhub.controllers.FrontendCacheSettingsController;
import com.roninpixels.dashboardhub.controllers.PerformanceSettingsController;
import com.roninpixels.dashboardhub.controllers.PublicLinkManagementController;
import com.roninpixels.dashboardhub.controllers.impl.DHPermissionControllerImpl;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.models.PermissionModel;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class AccessManagementControllerImpl
implements AccessManagementController {
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    @Inject
    @ComponentImport
    private PluginAccessor pluginAccessor;
    @Inject
    @ComponentImport
    private TransactionTemplate transactionTemplate;
    @Inject
    private DHPermissionController permissionController;
    @Inject
    private DHUserService userService;
    @Inject
    private PerformanceSettingsController performanceSettingsController;
    @Inject
    private DatasourceSettingsController datasourceSettingsController;
    @Inject
    private DatasourceRunAsOwnerSettingsController datasourceRunAsOwnerSettingsController;
    @Inject
    private DatasourceSharingSettingsController datasourceSharingSettingsController;
    @Inject
    private PublicLinkManagementController publicLinkManagementController;
    @Inject
    private FrontendCacheSettingsController frontendCacheConfigController;

    static List<PermissionModel> getPermissionsFrom(AppConfigModel config) {
        return DHPermissionControllerImpl.getPermissionsFrom(config.getAppAllowedUserGroups(), 99, "app");
    }

    AppConfigModel _updateConfig(AppConfigModel newConfig) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put("com.roninpixels.dashboardhub:access.management.appRestricted", (Object)newConfig.getAppRestricted().toString());
        pluginSettings.put("com.roninpixels.dashboardhub:access.management.customerPortal", (Object)newConfig.getCustomerPortal().toString());
        if (newConfig.getLinksPolicy() != null) {
            if (LINKS_POLICY_ALLOWED_VALUES.contains(newConfig.getLinksPolicy())) {
                pluginSettings.put("com.roninpixels.dashboardhub:global.settings.linksPolicy", (Object)newConfig.getLinksPolicy());
            } else {
                throw new IllegalArgumentException("Links policy not allowed: " + newConfig.getLinksPolicy());
            }
        }
        if (newConfig.getAppRestricted().booleanValue()) {
            List<String> usersGroups = newConfig.getAppAllowedUserGroups();
            this.permissionController.updateConfig(usersGroups, 99, "app");
        } else {
            this.permissionController.deletePermissions(99, "app");
        }
        if (newConfig.getPublicLinkSettings() != null) {
            this.publicLinkManagementController.updateSettings(newConfig.getPublicLinkSettings());
        }
        if (newConfig.getPerformanceSettings() != null) {
            this.performanceSettingsController.updatePerformanceSettings(newConfig.getPerformanceSettings());
        }
        if (newConfig.getFrontCacheSettings() != null) {
            this.frontendCacheConfigController.updateCacheSettings(newConfig.getFrontCacheSettings());
        }
        if (newConfig.getDatasourceCreationRestriction() != null) {
            this.datasourceSettingsController.updateSettings(newConfig.getDatasourceCreationRestriction());
        }
        if (newConfig.getDatasourceOwnerViewModeRestriction() != null) {
            this.datasourceRunAsOwnerSettingsController.updateSettings(newConfig.getDatasourceOwnerViewModeRestriction());
        }
        if (newConfig.getDatasourceShareRestriction() != null) {
            this.datasourceSharingSettingsController.updateSettings(newConfig.getDatasourceShareRestriction());
        }
        return this._getConfig();
    }

    @Override
    public AppConfigModel updateConfig(AppConfigModel newConfig) {
        return (AppConfigModel)this.transactionTemplate.execute(() -> this._updateConfig(newConfig));
    }

    AppConfigModel _getConfig() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        AppConfigModel config = new AppConfigModel();
        String appRestrictedStr = (String)settings.get("com.roninpixels.dashboardhub:access.management.appRestricted");
        config.setAppRestricted(appRestrictedStr != null && Boolean.parseBoolean(appRestrictedStr));
        config.setCustomerPortal(this.isCustomerPortalEnabled(settings));
        config.setLinksPolicy((String)settings.get("com.roninpixels.dashboardhub:global.settings.linksPolicy"));
        List<String> groupsAndUsers = this.permissionController.getUsersAndGroups(99, "app");
        config.setAppAllowedUserGroups(groupsAndUsers);
        config.setPublicLinkSettings(this.publicLinkManagementController.getSettings());
        config.setPerformanceSettings(this.performanceSettingsController.getPerformanceSettings());
        config.setFrontCacheSettings(this.frontendCacheConfigController.getCacheSettings());
        config.setDatasourceCreationRestriction(this.datasourceSettingsController.getSettings());
        config.setDatasourceOwnerViewModeRestriction(this.datasourceRunAsOwnerSettingsController.getSettings());
        config.setDatasourceShareRestriction(this.datasourceSharingSettingsController.getSettings());
        return config;
    }

    @Override
    public AppConfigModel getConfig() {
        return (AppConfigModel)this.transactionTemplate.execute(() -> this._getConfig());
    }

    @Override
    public AppConfigModel getConfig(boolean includeIsRestricted) {
        AppConfigModel appConfig = this.getConfig();
        if (includeIsRestricted) {
            appConfig.setRestrictedAccess(!this.canLoggedInUserAccess());
        }
        return appConfig;
    }

    @Override
    public AppConfigModel getAdminConfig() {
        AppConfigModel appConfig = new AppConfigModel();
        boolean isAdmin = this.userService.isLoggedUserAdmin();
        if (isAdmin) {
            appConfig = this.getConfig();
        }
        appConfig.setRestrictedAccess(!isAdmin);
        return appConfig;
    }

    @Override
    public boolean canUserAccess(String userKey) {
        return this.permissionController.isUserAllowedFor(userKey, 99);
    }

    @Override
    public boolean canLoggedInUserAccess() {
        AppConfigModel appConfig = this.getConfig();
        String userKey = this.userService.getLoggedInUserKey();
        return userKey != null && (appConfig.getAppRestricted() == false || this.canUserAccess(userKey));
    }

    @Override
    public boolean isCustomerPortalEnabled() {
        if (!this.isJsmLicensedForUse()) {
            return false;
        }
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        return this.isCustomerPortalEnabled(settings);
    }

    @Override
    public boolean isJsmLicensedForUse() {
        Plugin jsmPlugin = this.pluginAccessor.getEnabledPlugin("com.atlassian.servicedesk.application");
        return jsmPlugin != null;
    }

    private boolean isCustomerPortalEnabled(PluginSettings settings) {
        String customerPortalEnabledStr = (String)settings.get("com.roninpixels.dashboardhub:access.management.customerPortal");
        return customerPortalEnabledStr == null || Boolean.parseBoolean(customerPortalEnabledStr);
    }
}

