/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.defaultConfig;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.controllers.defaultConfig.DefaultDashboardController;
import com.roninpixels.dashboardhub.services.DHDefaultConfigGenerator;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class JiraDefaultConfigController
implements DefaultDashboardController {
    private static final Logger log = LoggerFactory.getLogger(JiraDefaultConfigController.class);
    @Inject
    private DatasourcesController datasourcesController;
    @Inject
    private ConnectorsProvider connectorsProvider;
    @Inject
    private DHDefaultConfigGenerator defaultConfigGenerator;
    @Inject
    private DHObjectMapper mapper;

    private Long getProjectId(JiraConnector connector, Long boardId) {
        List projects = (List)connector.getBoardProjects(boardId).getBody();
        return Long.parseLong((String)((Map)projects.get(0)).get("id"));
    }

    private Long getBoards(JiraConnector jiraConnector) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("maxResults", 1);
        params.put("type", "scrum");
        List boards = (List)jiraConnector.getBoards(params).getBody();
        return boards.isEmpty() ? null : Long.valueOf(((Number)((Map)boards.get(0)).get("id")).longValue());
    }

    private long getFilterIdFromBoardConfiguration(JiraConnector jiraConnector, long boardId) throws Exception {
        String rawBoardConfig = (String)jiraConnector.getBoardConfiguration(boardId).getBody();
        Map boardConfig = this.mapper.readValue(rawBoardConfig, Map.class);
        Map filter = (Map)boardConfig.get("filter");
        return Long.parseLong((String)filter.get("id"));
    }

    @Override
    public Map getDefaultInfoDashboard() {
        try {
            this.defaultConfigGenerator.ensureDefaultDatasource();
            DatasourceModel defaultDs = this.defaultConfigGenerator.getDefaultDatasource();
            JiraConnector jiraConnector = (JiraConnector)this.connectorsProvider.getConnector(defaultDs);
            Long boardId = this.getBoards(jiraConnector);
            if (boardId == null) {
                return Collections.emptyMap();
            }
            Long projectId = this.getProjectId(jiraConnector, boardId);
            long filterId = this.getFilterIdFromBoardConfiguration(jiraConnector, boardId);
            HashMap<String, Long> data = new HashMap<String, Long>();
            data.put("project", projectId);
            data.put("board", boardId);
            data.put("filterId", filterId);
            return data;
        }
        catch (Exception e) {
            log.error("Default dashboard creation failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

