/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.defaultConfig;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.controllers.DatasourcesControllerV2;
import com.roninpixels.dashboardhub.controllers.defaultConfig.DefaultDashboardController;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class ConfluenceDefaultConfigController
implements DefaultDashboardController {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceDefaultConfigController.class);
    @Inject
    private DatasourcesControllerV2 datasourcesController;
    @Inject
    private ConnectorsProvider connectorsProvider;
    @Inject
    private DHObjectMapper mapper;

    private DatasourceModel getDefaultDatasource() {
        try {
            return this.datasourcesController.getDatasources().stream().filter(ds -> Product.CONFLUENCE.value().equals(ds.getProduct()) && ProductHosting.DIRECT.value().equals(ds.getType())).findAny().orElse(null);
        }
        catch (IOException ioe) {
            log.error("Default datasource not found", (Throwable)ioe);
            return null;
        }
    }

    @Override
    public Map getDefaultInfoDashboard() {
        throw new UnsupportedOperationException();
    }
}

