/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ConfluenceCloudV2BaseFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfluenceCloudV2BaseFunc.class);
    private static final int SPACE_PAGINATION_SIZE_v2 = 250;
    protected final ServerConnector connector;

    public ConfluenceCloudV2BaseFunc(ServerConnector connector) {
        this.connector = connector;
    }

    List getAllElements(String path, Map params, Map options, int staticMaxElements) {
        boolean all = options != null ? options.getOrDefault("all", false) : false;
        Map<String, Integer> mParams = params != null ? new HashMap<String, Integer>(params) : new HashMap();
        mParams.putIfAbsent("limit", 250);
        int maxElements = all ? staticMaxElements : params.getOrDefault("limit", 1000);
        String currentPath = path;
        boolean hasMoreElements = true;
        LinkedList allElements = new LinkedList();
        while (hasMoreElements) {
            ResponseEntity<Map> responseEntity = this.connector.executeRequest(currentPath, mParams, Map.class);
            ResponseChecker.checkStatus(responseEntity);
            Map response = (Map)responseEntity.getBody();
            List spaces = (List)response.get("results");
            allElements.addAll(spaces);
            currentPath = ((Map)response.get("_links")).getOrDefault("next", null);
            if (currentPath != null && currentPath.startsWith("/wiki")) {
                currentPath = currentPath.substring(5);
            }
            mParams = Collections.emptyMap();
            hasMoreElements = currentPath != null && allElements.size() < maxElements;
        }
        return allElements;
    }
}

