/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.atlassianInsight.functions;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.atlassianInsight.functions.AQLCloudResponse;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.opsgenie.functions.GetOpsGenieDataFunc;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class SearchByAQLCloudFunc {
    private static final Logger log = LoggerFactory.getLogger(GetOpsGenieDataFunc.class);
    private static final int MAX_ELEMENTS = 1001;
    public static final String PATH = "/object/aql";
    private final ServerConnector connector;
    private DHObjectMapperImpl mapper = new DHObjectMapperImpl();

    public SearchByAQLCloudFunc(ServerConnector serverConnector) {
        this.connector = serverConnector;
    }

    String generateBody(String query) {
        try {
            Map<String, String> bodyObj = Collections.singletonMap("qlQuery", query);
            return this.mapper.writeValueAsString(bodyObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ResponseEntity<Map> exec(Map<String, String> params) {
        HashMap<String, String> mParams = params == null ? new HashMap<String, String>() : new HashMap<String, String>(params);
        mParams.putIfAbsent("maxResults", "100");
        String qlQuery = (String)mParams.remove("iql");
        String body = this.generateBody(qlQuery);
        LinkedList<Map> objectEntries = new LinkedList<Map>();
        LinkedList<Map> objectTypeAttributes = new LinkedList<Map>();
        int startAt = 0;
        boolean hasMore = true;
        while (hasMore) {
            mParams.put("startAt", "" + startAt);
            ResponseEntity<AQLCloudResponse> responseEntity = this.connector.executeRequest(Request.MethodType.POST, PATH, mParams, Collections.emptyMap(), body, AQLCloudResponse.class);
            ResponseChecker.checkStatus(responseEntity);
            AQLCloudResponse result = (AQLCloudResponse)responseEntity.getBody();
            objectEntries.addAll(result.getValues());
            objectTypeAttributes.addAll(result.getObjectTypeAttributes());
            hasMore = !result.isLast() && objectEntries.size() < 1001;
            startAt += result.getValues().size();
        }
        HashMap<String, LinkedList<Map>> data = new HashMap<String, LinkedList<Map>>();
        data.put("objectEntries", objectEntries);
        data.put("objectTypeAttributes", objectTypeAttributes);
        return new ResponseEntity(data, HttpStatus.OK);
    }
}

