/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.config;

import com.roninpixels.dashboardhub.config.frontedModel.PermissionDatasources;
import com.roninpixels.dashboardhub.config.frontedModel.PermissionPublicLinks;
import com.roninpixels.dashboardhub.config.frontedModel.PermissionsData;
import com.roninpixels.dashboardhub.controllers.DatasourceSettingsController;
import com.roninpixels.dashboardhub.controllers.PublicLinkManagementController;
import com.roninpixels.dashboardhub.services.UserPermissionsService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class UserPermissionsServiceImpl
implements UserPermissionsService {
    @Inject
    private PublicLinkManagementController publicLinkManagementController;
    @Inject
    private DatasourceSettingsController datasourceSettingsController;

    @Override
    public PermissionsData getPermissions(AppUser appUser) {
        PermissionsData permissions = new PermissionsData();
        PermissionPublicLinks publicLinks = new PermissionPublicLinks();
        if (appUser == null) {
            publicLinks.setCanEnable(false);
        } else {
            publicLinks.setCanEnable(this.publicLinkManagementController.canUserCreatePublicLinks(appUser.getKey()));
        }
        permissions.setPublicLinks(publicLinks);
        PermissionDatasources datasources = new PermissionDatasources();
        permissions.setDatasources(datasources);
        datasources.setCanCreate(appUser == null ? false : this.datasourceSettingsController.canUserCreateDatasources(appUser.getKey()));
        return permissions;
    }
}

