/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.app.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.TrustedRequestFactory;
import com.roninpixels.dashboardhub.app.RequestFactoryWrapper;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.services.DHWhitelistService;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;

public class TrustedRequestFactoryWrapper
implements RequestFactoryWrapper {
    @Inject
    @ComponentImport
    private TrustedRequestFactory<?> requestFactory;
    @Inject
    private DHWhitelistService dhWhiteListService;
    @Inject
    private DHObjectMapper mapper;

    @Override
    public Request createRequest(Request.MethodType method, String url) {
        if (!this.dhWhiteListService.isAllowed(url)) {
            String baseUrl = null;
            try {
                URI uri = new URI(url);
                baseUrl = uri.getScheme() + "://" + uri.getHost();
            }
            catch (Exception e) {
                baseUrl = url;
            }
            HashMap<String, String> errorMap = new HashMap<String, String>();
            errorMap.put("url", baseUrl);
            String errorMapStr = null;
            try {
                errorMapStr = this.mapper.writeValueAsString(errorMap);
            }
            catch (IOException e) {
                errorMapStr = "NOT_ALLOWED_DATASOURCE";
            }
            throw new DhUserException(403, "NOT_ALLOWED_DATASOURCE_WITH_URL", errorMapStr);
        }
        return this.requestFactory.createTrustedRequest(method, url);
    }
}

