/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub;

import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.ProjectService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/userGroups")
public class UserGroupsEndpoint {
    @Inject
    private DHUserService dhUserService;
    @Inject
    private ProjectService projectService;

    List<Map> getUsers(List<String> userKeys) {
        return userKeys.parallelStream().map(key -> {
            AppUser user = this.dhUserService.getUserByKey((String)key, true);
            if (user == null) {
                return null;
            }
            HashMap<String, Object> userData = new HashMap<String, Object>();
            userData.put("accountId", key);
            userData.put("accountType", user.getAccountType());
            userData.put("displayName", user.getDisplayName());
            HashMap<String, String> avatarUrls = new HashMap<String, String>();
            avatarUrls.put("16x16", user.getAvatarUrl());
            userData.put("avatarUrls", avatarUrls);
            userData.put("avatarUrl", user.getAvatarUrl());
            return userData;
        }).filter(userData -> userData != null).collect(Collectors.toList());
    }

    List<Map> getGroups(List<String> groupNames) {
        return groupNames.parallelStream().map(key -> {
            HashMap<String, String> userData = new HashMap<String, String>();
            userData.put("groupId", (String)key);
            userData.put("name", (String)key);
            return userData;
        }).collect(Collectors.toList());
    }

    List<Map> getProjects(List<String> projectKeys) {
        String loggedUserKey = this.dhUserService.getLoggedInUserKey();
        Collection<Map> userProjects = this.projectService.getProjectsFor(loggedUserKey, projectKeys);
        return userProjects.stream().map(project -> {
            HashMap projectData = new HashMap();
            projectData.put("key", project.get("key"));
            projectData.put("name", project.get("name"));
            projectData.put("avatarUrls", project.get("avatarUrls"));
            projectData.put("avatarUrl", ((Map)project.get("avatarUrls")).get("16x16"));
            return projectData;
        }).collect(Collectors.toList());
    }

    @GET
    @Path(value="/bulk")
    @Produces(value={"application/json"})
    public Response getBoardByToken(@QueryParam(value="ids") String ids, @Context HttpServletRequest request) {
        Map<String, List<String>> usersAndGroups = RestrictionsUtil.breakDownUsersGroupsProjects(ids);
        List<String> userKeys = usersAndGroups.get("users");
        List<String> groupNames = usersAndGroups.get("groups");
        List<String> projectKeys = usersAndGroups.get("projects");
        List<Object> users = new ArrayList();
        List<Object> groups = new ArrayList();
        List<Object> projects = new ArrayList();
        HashMap<String, String> errors = new HashMap<String, String>();
        try {
            if (userKeys != null && !userKeys.isEmpty()) {
                users = this.getUsers(userKeys);
            }
        }
        catch (Exception e) {
            errors.put("users", e.getMessage());
        }
        try {
            if (groupNames != null && !groupNames.isEmpty()) {
                groups = this.getGroups(groupNames);
            }
        }
        catch (Exception e) {
            errors.put("groups", e.getMessage());
        }
        try {
            if (projectKeys != null && !projectKeys.isEmpty()) {
                projects = this.getProjects(projectKeys);
            }
        }
        catch (Exception e) {
            errors.put("projects", e.getMessage());
        }
        HashMap<String, Cloneable> responseData = new HashMap<String, Cloneable>();
        responseData.put("groups", (Cloneable)((Object)groups));
        responseData.put("users", (Cloneable)((Object)users));
        responseData.put("projects", (Cloneable)((Object)projects));
        if (!errors.isEmpty()) {
            responseData.put("errors", errors);
        }
        return ResponseBuilder.ok(responseData).build();
    }
}

