/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.permissions;

import com.roninpixels.dashboardhub.utils.permissions.BoardRestrictionsConfig;
import com.roninpixels.dashboardhub.web.models.RestrictionsModel;
import com.roninpixels.dashboardhub.web.models.UserGroupsModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RestrictionsUtil {
    public static Map<String, List<String>> breakDownUsersGroupsProjects(RestrictionsModel restrictions) {
        UserGroupsModel userGroups = restrictions.getUserGroups();
        return RestrictionsUtil.breakDownUsersGroupsProjects(Stream.concat(userGroups.getCanView().stream(), Stream.concat(userGroups.getCanEdit().stream(), userGroups.getCanUse().stream())).collect(Collectors.toList()));
    }

    public static Map<String, List<String>> breakDownUsersGroupsProjects(List<String> groupAndUsers) {
        LinkedList<String> userKeys = new LinkedList<String>();
        LinkedList<String> groupNames = new LinkedList<String>();
        LinkedList<String> projectKeys = new LinkedList<String>();
        if (groupAndUsers != null && !groupAndUsers.isEmpty()) {
            block11: for (String element : groupAndUsers) {
                String elem = element.trim();
                if (!elem.contains(":")) continue;
                int idx = elem.indexOf(58);
                String prefix = elem.substring(0, idx);
                String id = elem.substring(idx + 1);
                switch (prefix) {
                    case "accountId": 
                    case "userId": {
                        userKeys.add(id);
                        continue block11;
                    }
                    case "groupId": {
                        groupNames.add(id);
                        continue block11;
                    }
                    case "projectKey": {
                        projectKeys.add(id);
                        continue block11;
                    }
                }
                throw new RuntimeException("Not supported: " + elem + " in " + groupAndUsers);
            }
        }
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        data.put("users", userKeys);
        data.put("groups", groupNames);
        data.put("projects", projectKeys);
        return data;
    }

    public static Map<String, List<String>> breakDownUsersGroupsProjects(String groupAndUsers) {
        return RestrictionsUtil.breakDownUsersGroupsProjects(Arrays.asList(groupAndUsers.split(",")));
    }

    public static BoardRestrictionsConfig getRestrictionsConfig(RestrictionsModel restrictions) {
        return new BoardRestrictionsConfig(restrictions);
    }

    public static String getHolderType(String key) {
        if (key.startsWith("user")) {
            return "user";
        }
        if (key.startsWith("group")) {
            return "group";
        }
        if (key.startsWith("project")) {
            return "project";
        }
        return null;
    }
}

