/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.permissions.rules;

import com.roninpixels.dashboardhub.permissions.EditPermission;
import com.roninpixels.dashboardhub.permissions.ViewPermission;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.models.RestrictionModel;
import com.roninpixels.dashboardhub.web.models.RestrictionsModel;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="anyViewEdit")
public class AnyoneCanEditViewRule
implements ViewPermission,
EditPermission {
    public static final String PERMISSION_TYPE = "anyViewEdit";
    @Inject
    private DHUserService dhUserService;

    @Override
    public boolean evaluateView(RestrictionModel restrictionModel) {
        RestrictionsModel restrictions = restrictionModel.getRestrictions();
        return restrictions == null || PERMISSION_TYPE.equals(restrictions.getType());
    }

    @Override
    public boolean evaluateEdit(RestrictionModel restrictionModel) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        return this.evaluateView(restrictionModel);
    }
}

