/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture.utils;

import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxFlattened;
import com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture.utils.CommonUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customChartsConfig.BQLSearchConfig;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class BoxFilterUtils {
    public static final String KEY_BY_IDS = "BY_IDS";
    public static final String KEY_BY_SEARCH_TERM = "BY_SEARCH_TERM";
    public static final String KEY_BY_TYPE = "BY_TYPE";
    public static final String KEY_BY_STATUS = "BY_STATUS";
    public static final String KEY_BY_DATE_RANGE = "BY_DATE_RANGE";

    public static List<BoxFlattened> getFilteredBoxes(List<BoxFlattened> boxFlatteneds, BQLSearchConfig config) {
        Map<String, Object> boxFiltersMap = BoxFilterUtils.getBoxFilters(config);
        return boxFlatteneds.stream().filter(box -> BoxFilterUtils.applyFilters(box, boxFiltersMap)).collect(Collectors.toList());
    }

    private static boolean applyFilters(BoxFlattened box, Map<String, Object> filters) {
        return BoxFilterUtils.filterByIds(box, filters) && BoxFilterUtils.filterBySearchTerm(box, filters) && BoxFilterUtils.filterByType(box, filters) && BoxFilterUtils.filterByStatus(box, filters) && BoxFilterUtils.filterByDateRange(box, filters);
    }

    private static boolean filterByIds(BoxFlattened box, Map<String, Object> filters) {
        List boxIds = (List)BoxFilterUtils.getFilterValue(filters, KEY_BY_IDS);
        return CommonUtils.isNullOrEmpty(boxIds) || boxIds.contains(box.getId());
    }

    private static boolean filterBySearchTerm(BoxFlattened box, Map<String, Object> filters) {
        String searchTerm = Optional.ofNullable((String)BoxFilterUtils.getFilterValue(filters, KEY_BY_SEARCH_TERM)).map(String::trim).map(String::toLowerCase).orElse("");
        return searchTerm.isEmpty() || box.getName().toLowerCase().contains(searchTerm) || box.getDescription().toLowerCase().contains(searchTerm);
    }

    private static boolean filterByType(BoxFlattened box, Map<String, Object> filters) {
        List boxTypes = (List)BoxFilterUtils.getFilterValue(filters, KEY_BY_TYPE);
        return CommonUtils.isNullOrEmpty(boxTypes) || boxTypes.contains(box.getTypeId());
    }

    private static boolean filterByStatus(BoxFlattened box, Map<String, Object> filters) {
        List boxStatuses = (List)BoxFilterUtils.getFilterValue(filters, KEY_BY_STATUS);
        return CommonUtils.isNullOrEmpty(boxStatuses) || boxStatuses.contains(box.getStatusId());
    }

    private static boolean filterByDateRange(BoxFlattened box, Map<String, Object> filters) {
        Map dateRange = (Map)BoxFilterUtils.getFilterValue(filters, KEY_BY_DATE_RANGE);
        if (dateRange == null || CommonUtils.isEmpty((String)dateRange.get("startDate")) && CommonUtils.isEmpty((String)dateRange.get("endDate"))) {
            return true;
        }
        Date filterStartDate = CommonUtils.parseDate((String)dateRange.get("startDate"));
        Date filterEndDate = CommonUtils.parseDate((String)dateRange.get("endDate"));
        Date boxStartDate = CommonUtils.parseDate(box.getStartDate());
        Date boxEndDate = CommonUtils.parseDate(box.getEndDate());
        return (filterStartDate == null || boxStartDate != null && !boxStartDate.before(filterStartDate)) && (filterEndDate == null || boxEndDate != null && !boxEndDate.after(filterEndDate));
    }

    private static <T> T getFilterValue(Map<String, Object> filters, String key) {
        return (T)filters.get(key);
    }

    public static Map<String, Object> getBoxFilters(BQLSearchConfig config) {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put(KEY_BY_IDS, config.getBoxes().stream().map(box -> box.get("id")).collect(Collectors.toList()));
        filters.put(KEY_BY_SEARCH_TERM, config.getSearchTerm());
        filters.put(KEY_BY_TYPE, config.getBoxTypes());
        filters.put(KEY_BY_STATUS, config.getBoxStatuses());
        HashMap<String, String> dateRange = new HashMap<String, String>();
        dateRange.put("startDate", config.getMinStartDate());
        dateRange.put("endDate", config.getMaxEndDate());
        filters.put(KEY_BY_DATE_RANGE, dateRange);
        return filters;
    }
}

