/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources;

import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import com.roninpixels.dashboardhub.web.models.RestrictionsModel;

public interface DatasourcesUtil {
    public DatasourceModel generateTemporal(DatasourceModel var1, DsOptionsModel var2);

    public DsOptionsModel getSecretOptions(String var1);

    public static DsOptionsModel decryptOptions(Crypto crypto, String token) {
        try {
            return new DHObjectMapperImpl().readValue(crypto.decryptBackend(token), DsOptionsModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isDefaultDatasource(DatasourceModel datasource, String product, String creator) {
        return DatasourcesUtil.isDefaultDatasource(datasource, Product.fromString(product), creator);
    }

    public static boolean isDefaultDatasource(DatasourceModel datasource, Product product, String creator) {
        return (product == Product.JIRA || product == Product.CONFLUENCE) && product.value().equals(datasource.getProduct()) && datasource.getFirst() != false && ProductHosting.DIRECT.value().equals(datasource.getType()) && datasource.getCreator().equals(creator);
    }

    public static boolean canRunAsViewer(DatasourceModel datasource) {
        return ProductHosting.SELF.value().equals(datasource.getType()) || ProductHosting.DIRECT.value().equals(datasource.getType());
    }

    public static RestrictionsModel createDefaultDatasourceRestrictions() {
        RestrictionsModel restrictions = new RestrictionsModel();
        restrictions.setType("someUseSomeEdit");
        return restrictions;
    }

    public static void setPrivateBasedOnRestrictionType(DatasourceModel ds) {
        if (ds.getRestrictions() == null) {
            ds.setPrivate(false);
            ds.setRestrictionType("anyUseSomeEdit");
        } else {
            ds.setPrivate(ds.getRestrictions().getType().equals("someUseSomeEdit"));
            ds.setRestrictionType(ds.getRestrictions().getType());
        }
    }

    public static void setRestrictionTypeBasedOnRestrictions(DatasourceModel dsModel) {
        if (dsModel.getRestrictions() == null) {
            if (dsModel.getPrivate().booleanValue()) {
                dsModel.setRestrictionType("someUseSomeEdit");
            } else {
                dsModel.setRestrictionType("anyUseSomeEdit");
            }
        } else {
            dsModel.setRestrictionType(dsModel.getRestrictions().getType());
        }
    }

    public static void setNewRestrictions(DatasourceModel ds) {
        if (ds != null && ds.getRestrictions() == null) {
            ds.setRestrictions(new RestrictionsModel());
            if (ds.getPrivate() != null && ds.getPrivate().booleanValue()) {
                ds.getRestrictions().setType("someUseSomeEdit");
            } else {
                ds.getRestrictions().setType("anyUseSomeEdit");
            }
        }
    }
}

