/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.controllers.BoardActionsValidator;
import com.roninpixels.dashboardhub.controllers.BoardPermissionsController;
import com.roninpixels.dashboardhub.controllers.BoardTokenController;
import com.roninpixels.dashboardhub.controllers.BoardUserPreferencesController;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.controllers.providers.BoardsProvider;
import com.roninpixels.dashboardhub.exceptions.BoardValidationException;
import com.roninpixels.dashboardhub.permissions.AccessManager;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.store.DHBoardsRepository;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.BoardSharingModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.EncryptedBoardModel;
import com.roninpixels.dashboardhub.web.models.GadgetConfigModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class BoardsControllerImpl
implements BoardsController {
    private static final Logger log = LoggerFactory.getLogger(BoardsControllerImpl.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private AccessManager boardAccessManager;
    @Inject
    private BoardPermissionsController boardPermissionsController;
    @Inject
    private BoardTokenController boardTokenController;
    @Inject
    private DHBoardsRepository boardsRepo;
    @Inject
    private Crypto mCrypto;
    @Inject
    private BoardUserPreferencesController boardUserPreferencesController;
    @Inject
    private BoardActionsValidator boardActionsValidator;
    @Autowired(required=false)
    private Provider<List<BoardsProvider>> boardsProviders;
    @Inject
    private DHObjectMapper mMapper;

    private List<String> getBoardIds(Boolean global) throws IOException {
        if (global.booleanValue()) {
            return this.boardsRepo.getGlobalBoardsKeys();
        }
        String userKey = this.dhUserService.getLoggedInUserKey();
        return this.boardsRepo.getPrivateBoardsKeysForUser(userKey);
    }

    @Override
    public BoardModel getBoard(String id, Boolean global) {
        try {
            BoardModel board = this.getBoard(id);
            return board == null || global != board.getGlobal() ? null : board;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BoardModel getBoard(String id) {
        EncryptedBoardModel encryptedBoard = this.boardsRepo.getBoard(id);
        if (encryptedBoard == null) {
            return null;
        }
        return this.decryptBoard(encryptedBoard);
    }

    @Override
    public List getAllBoards(Boolean global, Boolean expand) throws Exception {
        List<EncryptedBoardModel> encrypedBoards;
        if (!expand.booleanValue()) {
            return this.getBoardIds(global);
        }
        if (global.booleanValue()) {
            encrypedBoards = this.boardsRepo.getAllBoards();
        } else {
            String userKey = this.dhUserService.getLoggedInUserKey();
            encrypedBoards = this.boardsRepo.getPrivateBoards(userKey);
        }
        List boards = encrypedBoards.stream().map(encryptedBoard -> this.decryptBoard((EncryptedBoardModel)encryptedBoard)).filter(board -> board != null).collect(Collectors.toList());
        return boards;
    }

    @Override
    public List getAllSharedWithMeBoards(Boolean expand) {
        LinkedList boardFinalIds = new LinkedList();
        List<String> sharedBoardIds = this.boardPermissionsController.getAccesibleBoardIdsForLoggedUser();
        if (!sharedBoardIds.isEmpty()) {
            List<String> userBoards = this.boardsRepo.getAllBoardKeys(this.dhUserService.getLoggedInUserKey());
            List boardIds = sharedBoardIds.stream().filter(sharedId -> !userBoards.contains(sharedId)).collect(Collectors.toList());
            boardFinalIds.addAll(boardIds);
        }
        return expand == false ? boardFinalIds : boardFinalIds.stream().map(this::getBoard).collect(Collectors.toList());
    }

    @Override
    public BoardModel getUserBoard(String user, String id, Boolean global) throws Exception {
        BoardModel board = this.getBoard(id, global);
        return board.getOwner().equals(user) ? board : null;
    }

    @Override
    public BoardModel addBoard(BoardModel board) throws Exception {
        this.boardActionsValidator.validateCreate(board);
        this.boardTokenController.updateToken(board);
        this.updateRequiredDatasources(board);
        EncryptedBoardModel encrypted = this.generateEncryptedBoard(board);
        EncryptedBoardModel savedEncrypted = this.boardsRepo.addBoard(encrypted);
        String json = this.mCrypto.decryptBackend(savedEncrypted.getData());
        BoardModel newBoard = this.mMapper.readValue(json, BoardModel.class);
        this.boardPermissionsController.updateBoardPermissions(newBoard);
        return newBoard;
    }

    @Override
    public BoardModel updateBoard(BoardModel board) throws Exception {
        BoardModel originalBoard = this.getBoard(board.getId());
        this.boardActionsValidator.validateUpdate(board, originalBoard);
        this.boardTokenController.updateToken(board);
        this.updateRequiredDatasources(board);
        EncryptedBoardModel encrypted = this.generateEncryptedBoard(board);
        EncryptedBoardModel savedEncrypted = this.boardsRepo.updateBoard(encrypted);
        String json = this.mCrypto.decryptBackend(savedEncrypted.getData());
        BoardModel updatedBoard = this.mMapper.readValue(json, BoardModel.class);
        this.boardPermissionsController.updateBoardPermissions(updatedBoard);
        return updatedBoard;
    }

    @Override
    public boolean removeBoard(String boardId, Boolean global) {
        try {
            BoardModel storedBoard = this.getBoard(boardId);
            this.boardActionsValidator.validateDelete(storedBoard);
        }
        catch (BoardValidationException bde) {
            return false;
        }
        boolean removed = this.boardsRepo.removeBoard(boardId);
        if (removed) {
            this.boardPermissionsController.removeBoardPermissions(boardId);
            this.boardUserPreferencesController.removeBoardUserPreferences(boardId);
        }
        return removed;
    }

    private BoardSharingModel getSharingByAction(BoardSharingModel sharing) {
        BoardSharingModel newSharing;
        if (sharing != null && sharing.getAction() != null) {
            newSharing = new BoardSharingModel();
            newSharing.setPublic(sharing.getPublic());
            newSharing.setPassword(sharing.getPassword());
            switch (sharing.getAction()) {
                case "delete_password": {
                    newSharing.setPassword(null);
                    break;
                }
                default: {
                    String hashedPass = this.mCrypto.hashString(sharing.getPassword());
                    newSharing.setPassword(hashedPass);
                    break;
                }
            }
        } else {
            newSharing = sharing;
        }
        return newSharing;
    }

    @Override
    public EncryptedBoardModel generateEncryptedBoard(BoardModel board) throws Exception {
        EncryptedBoardModel encrypted = new EncryptedBoardModel();
        encrypted.setId(board.getId());
        encrypted.setName(board.getName());
        encrypted.setOwner(board.getOwner());
        encrypted.setCreated(board.getCreated());
        encrypted.setUpdated(board.getUpdated());
        encrypted.setGlobal(board.getGlobal());
        board.setSharing(this.getSharingByAction(board.getSharing()));
        String json = this.mMapper.writeValueAsString(board);
        encrypted.setData(this.mCrypto.encryptBackend(json));
        return encrypted;
    }

    @Override
    public BoardModel decryptBoard(EncryptedBoardModel encryptedBoard) {
        BoardModel result = null;
        if (encryptedBoard != null) {
            try {
                String json = this.mCrypto.decryptBackend(encryptedBoard.getData());
                result = this.mMapper.readValue(json, BoardModel.class);
            }
            catch (Exception e) {
                log.error("Problems with board: " + encryptedBoard.getId(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public boolean checkUserLoggedCanView(BoardModel board) {
        return this.boardAccessManager.canUserLoggedInView(board);
    }

    @Override
    public boolean checkUserLoggedCanEdit(BoardModel board) {
        return this.boardAccessManager.canUserLoggedInEdit(board);
    }

    @Override
    public BoardModel cloneBoard(BoardModel board, String originalBoardId) throws Exception {
        BoardModel originalBoard = this.getBoard(originalBoardId);
        this.boardActionsValidator.validateClone(originalBoard);
        List<List<GadgetModel>> newData = originalBoard.getData().stream().map(slide -> slide.stream().map(gadget -> {
            gadget.setId(UUID.randomUUID().toString());
            return gadget;
        }).collect(Collectors.toList())).collect(Collectors.toList());
        this.boardTokenController.updateToken(board);
        board.setData(newData);
        board.setProduct(originalBoard.getProduct());
        board.setConfig(originalBoard.getConfig());
        EncryptedBoardModel encrypted = this.generateEncryptedBoard(board);
        EncryptedBoardModel savedEncrypted = this.boardsRepo.addBoard(encrypted);
        String json = this.mCrypto.decryptBackend(savedEncrypted.getData());
        BoardModel newBoard = this.mMapper.readValue(json, BoardModel.class);
        this.boardPermissionsController.updateBoardPermissions(newBoard);
        return newBoard;
    }

    protected void updateRequiredDatasources(BoardModel board) {
        List<String> dsIds = board.getData().stream().flatMap(Collection::stream).flatMap(gadget -> {
            LinkedList<DatasourceModel> list = new LinkedList<DatasourceModel>();
            GadgetConfigModel config = gadget.getConfig();
            if (config != null) {
                list.add(config.getDatasource());
                if (config.getDatasources() != null) {
                    list.addAll(config.getDatasources());
                }
            }
            return list.stream();
        }).filter(Objects::nonNull).map(DatasourceModel::getId).distinct().collect(Collectors.toList());
        board.setRequiredDatasources(dsIds);
    }
}

