/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.controllers.DatasourcePermissionsController;
import com.roninpixels.dashboardhub.datasources.DatasourceGenerator;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.exceptions.BadDatasourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.permissions.AccessManager;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.store.DHDatasourcesRepository;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import com.roninpixels.dashboardhub.web.models.GadgetConfigModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.models.RestrictionModel;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DatasourcesControllerV2
implements DatasourcesController {
    private static final Logger log = LoggerFactory.getLogger(DatasourcesControllerV2.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private DHDatasourcesRepository dsRepo;
    @Inject
    private DatasourceGenerator dsGenerator;
    @Inject
    private DatasourcesUtil dsUtils;
    @Inject
    private DatasourcePermissionsController dsPermissionsController;
    @Inject
    private AccessManager dsAccessManager;

    @Override
    public List<DatasourceModel> getDatasources(String userKey) throws IOException {
        if (userKey == null) {
            return Collections.emptyList();
        }
        List<DatasourceModel> ownerDatasources = this.getOwnerDatasources(userKey);
        List ownerDatasourcesIds = ownerDatasources.stream().map(DatasourceModel::getId).collect(Collectors.toList());
        List<DatasourceModel> sharedWithMeDatasources = this.getSharedWithMeDatasources(userKey).stream().filter(ds -> !ownerDatasourcesIds.contains(ds.getId())).collect(Collectors.toList());
        List sharedWithMeDatasourcesIds = sharedWithMeDatasources.stream().map(DatasourceModel::getId).collect(Collectors.toList());
        List globalDatasources = this.getGlobalDatasources(userKey).stream().filter(ds -> !sharedWithMeDatasourcesIds.contains(ds.getId()) && !ownerDatasourcesIds.contains(ds.getId())).collect(Collectors.toList());
        this.setEditPermissionsIfNeeded(sharedWithMeDatasources);
        return Stream.concat(Stream.concat(ownerDatasources.stream(), globalDatasources.stream()), sharedWithMeDatasources.stream()).collect(Collectors.toList());
    }

    private void setEditPermissionsIfNeeded(List<DatasourceModel> datasources) {
        datasources.stream().forEach(ds -> {
            if (this.dsAccessManager.canUserLoggedInEdit((RestrictionModel)ds)) {
                ds.setPermission("canEdit");
            }
        });
    }

    private List<DatasourceModel> getSharedWithMeDatasources(String userKey) {
        List<DatasourceModel> sharedWithMeDatasources = this.dsPermissionsController.getAccesibleDatasourceIds(userKey).stream().map(dsId -> {
            try {
                DatasourceModel ds = this.getDatasource((String)dsId);
                ds.setPermission("canUse");
                return ds;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return sharedWithMeDatasources;
    }

    private List<DatasourceModel> getOwnerDatasources(String ownerKey) {
        List<DatasourceModel> ownerDatasources = this.dsRepo.getDatasourcesByOwner(ownerKey);
        ownerDatasources.stream().forEach(ds -> ds.setPermission("canEdit"));
        return ownerDatasources;
    }

    private List<DatasourceModel> getGlobalDatasources(String ownerKey) {
        List<DatasourceModel> globalDatasources = this.dsRepo.getGlobalDatasources();
        return globalDatasources.stream().filter(ds -> ds.getCreator() != ownerKey).map(ds -> {
            if (ds.getRestrictions() != null && ds.getRestrictions().getType().equals("anyUseEdit")) {
                ds.setPermission("canEdit");
            } else {
                ds.setPermission("canUse");
            }
            return ds;
        }).collect(Collectors.toList());
    }

    @Override
    public List<DatasourceModel> getDatasources() throws IOException {
        AppUser user = this.dhUserService.getLoggedInUser();
        return this.getDatasources(user == null ? null : user.getKey());
    }

    @Override
    public DatasourceModel getDatasource(String id) throws IOException {
        DatasourceModel ds = this.dsRepo.getDatasource(id);
        DatasourcesUtil.setNewRestrictions(ds);
        return ds;
    }

    @Override
    public DatasourceModel getDatasourceWithExtraInfo(String id) throws IOException {
        DatasourceModel targetDs = this.dsRepo.getDatasourceWithExtraInfo(id);
        DatasourcesUtil.setNewRestrictions(targetDs);
        String currentUserKey = this.dhUserService.getLoggedInUserKey();
        String creator = targetDs.getCreator();
        if (!creator.equals(currentUserKey) && !this.dsAccessManager.canUserLoggedInEdit(targetDs)) {
            throw new DhUserException(403, "FORBIDDEN_DATASOURCE_OWNER", "Data source creator different than logged in user or user has no permissions to edit the datasource");
        }
        return targetDs;
    }

    @Override
    public DatasourceModel addDatasource(DatasourceModel newDs) throws IOException {
        List<DatasourceModel> datasources = this.getDatasources();
        DatasourceModel actualNewDs = this.dsGenerator.generateDatasource(newDs, datasources);
        DatasourceModel addedDatasource = this.dsRepo.addDatasource(actualNewDs);
        this.dsPermissionsController.updateDatasourcePermissions(addedDatasource);
        return addedDatasource;
    }

    @Override
    public DatasourceModel updateDatasource(DatasourceModel updatedDs) throws IOException {
        if (updatedDs.getId() == null) {
            throw new BadDatasourceException("The data source id cannot be null");
        }
        DatasourceModel targetDs = this.dsRepo.getDatasource(updatedDs.getId());
        DatasourcesUtil.setNewRestrictions(targetDs);
        String currentUserKey = this.dhUserService.getLoggedInUserKey();
        String creator = targetDs.getCreator();
        if (!creator.equals(currentUserKey) && !this.dsAccessManager.canUserLoggedInEdit(targetDs)) {
            throw new DhUserException(403, "FORBIDDEN_DATASOURCE_OWNER", "Data source creator different than logged in user or user has no permissions to edit the datasource");
        }
        targetDs.setName(updatedDs.getName());
        targetDs.setType(updatedDs.getType());
        targetDs.setPrivate(updatedDs.getPrivate());
        targetDs.setRestrictions(updatedDs.getRestrictions());
        if (targetDs.getUrl() == null || targetDs.getUrl().equals(updatedDs.getUrl())) {
            DsOptionsModel options;
            if (targetDs.getUrl() == null) {
                targetDs.setUrl(updatedDs.getUrl());
            }
            DsOptionsModel newDsOptions = new DsOptionsModel();
            DsOptionsModel oldDsOptions = this.dsUtils.getSecretOptions(targetDs.getToken());
            Map oldDsOptionsOption = oldDsOptions.getOption("options", Map.class);
            if (oldDsOptionsOption != null) {
                oldDsOptionsOption.forEach(newDsOptions::addOtherConfig);
            }
            if ((options = updatedDs.getOptions()) != null && options.getOtherConfig() != null && !options.getOtherConfig().isEmpty()) {
                options.getOtherConfig().forEach(newDsOptions::addOtherConfig);
            }
            targetDs.setToken(null);
            targetDs.setOptions(newDsOptions);
        } else {
            targetDs.setUrl(updatedDs.getUrl());
            targetDs.setOptions(updatedDs.getOptions());
        }
        DatasourceModel newDs = this.dsGenerator.generateDatasource(targetDs, Collections.emptyList());
        DatasourceModel updatedDatasource = this.dsRepo.updateDatasource(newDs);
        this.dsPermissionsController.updateDatasourcePermissions(updatedDatasource);
        return updatedDatasource;
    }

    @Override
    public DatasourceModel removeDatasource(String id) throws IOException {
        String userKey = this.dhUserService.getLoggedInUserKey();
        DatasourceModel ds = this.getDatasource(id);
        if (!this.dhUserService.isLoggedUserAdmin().booleanValue() && !ds.getCreator().equals(userKey)) {
            log.error("Problems with datasource: User not allowed to remove datasource.");
            throw new RuntimeException("User not allowed to remove datasource");
        }
        DatasourceModel removedDs = this.dsRepo.removeDatasource(id);
        if (removedDs != null) {
            this.dsPermissionsController.removeDatasourcePermissions(id);
        }
        return removedDs;
    }

    @Override
    public DatasourceModel getDefaultDatasource(String creator, String product) throws IOException {
        List<DatasourceModel> privateDatasources = this.dsRepo.getDatasourcesByOwner(creator);
        return privateDatasources.stream().filter(ds -> DatasourcesUtil.isDefaultDatasource(ds, product, creator)).findFirst().map(ds -> {
            DatasourcesUtil.setNewRestrictions(ds);
            return ds;
        }).orElse(null);
    }

    @Override
    public void updateBoardDatasourcesWithNewOwner(BoardModel board, String newOwner) throws IOException {
        DatasourceModel newInstanceDatasource = this.getDefaultDatasource(newOwner, board.getProduct());
        if (newInstanceDatasource == null || board.getData() == null) {
            return;
        }
        AtomicBoolean instanceDatasourceAdded = new AtomicBoolean(false);
        List<List<GadgetModel>> updatedData = this.updateGadgetsWithNewDatasource(board, newInstanceDatasource, instanceDatasourceAdded);
        List<String> gadgetDatasourceIds = this.extractGadgetDatasourceIds(updatedData);
        List<DatasourceModel> boardDatasources = this.filterAndMapBoardDatasources(board, gadgetDatasourceIds);
        this.addNewInstanceDatasourceIfNeeded(boardDatasources, newInstanceDatasource, instanceDatasourceAdded);
        board.setDatasources(boardDatasources.stream().collect(Collectors.toMap(DatasourceModel::getId, ds -> new DatasourceModel(ds.getCreator(), ds.getPrivate()))));
        board.setData(updatedData);
    }

    private List<List<GadgetModel>> updateGadgetsWithNewDatasource(BoardModel board, DatasourceModel newInstanceDatasource, AtomicBoolean instanceDatasourceAdded) {
        return board.getData().stream().map(slide -> slide.stream().map(gadget -> {
            DatasourceModel existingDatasource;
            if (gadget.getConfig() == null || gadget.getConfig().getDatasource() == null) {
                return gadget;
            }
            try {
                existingDatasource = this.getDatasource(gadget.getConfig().getDatasource().getId());
            }
            catch (IOException e) {
                throw new RuntimeException("Problems getting datasource", e);
            }
            if (existingDatasource != null && DatasourcesUtil.isDefaultDatasource(existingDatasource, board.getProduct(), existingDatasource.getCreator())) {
                instanceDatasourceAdded.set(true);
                gadget.getConfig().setDatasource(new DatasourceModel(newInstanceDatasource.getId()));
            }
            return gadget;
        }).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List<String> extractGadgetDatasourceIds(List<List<GadgetModel>> updatedData) {
        return updatedData.stream().flatMap(Collection::stream).map(gadget -> Optional.ofNullable(gadget.getConfig()).map(GadgetConfigModel::getDatasource).map(DatasourceModel::getId).orElse(null)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private List<DatasourceModel> filterAndMapBoardDatasources(BoardModel board, List<String> gadgetDatasourceIds) {
        return board.getDatasources().entrySet().stream().filter(entry -> gadgetDatasourceIds.contains(entry.getKey())).map(entry -> {
            ((DatasourceModel)entry.getValue()).setId((String)entry.getKey());
            return (DatasourceModel)entry.getValue();
        }).collect(Collectors.toList());
    }

    private void addNewInstanceDatasourceIfNeeded(List<DatasourceModel> boardDatasources, DatasourceModel newInstanceDatasource, AtomicBoolean instanceDatasourceAdded) {
        if (instanceDatasourceAdded.get() && boardDatasources.stream().noneMatch(ds -> ds.getId().equals(newInstanceDatasource.getId()))) {
            DatasourceModel reducedDatasource = new DatasourceModel(newInstanceDatasource.getId());
            reducedDatasource.setCreator(newInstanceDatasource.getCreator());
            reducedDatasource.setPrivate(newInstanceDatasource.getPrivate());
            boardDatasources.add(reducedDatasource);
        }
    }
}

