/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.common.functions;

import com.roninpixels.dashboardhub.connectors.configs.JiraIntegrationProperties;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.globals.DefaultFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecJQLFunc {
    private static final Logger log = LoggerFactory.getLogger(ExecJQLFunc.class);
    public static final int DEFAULT_PAGE_SIZE = 100;
    protected final ServerConnector connector;
    private final int MAX_JQL;
    protected final int PARALLEL_REQUESTS;

    public ExecJQLFunc(ServerConnector connector, JiraIntegrationProperties jiraProps) {
        this.connector = connector;
        this.MAX_JQL = jiraProps.getMaxIssues();
        this.PARALLEL_REQUESTS = jiraProps.getParallelRequesters();
    }

    protected abstract JQLResponse executeSearchStrategy(Map<String, Object> var1, int var2) throws Exception;

    public boolean jqlIsAPredefinedFilter(String jql) {
        return jql.matches("filter\\s*=\\s*-[0-9]");
    }

    public Long getFilterId(String jql) {
        Pattern p = Pattern.compile("-[0-9]");
        Matcher m = p.matcher(jql);
        return m.find() ? Long.valueOf(Long.parseLong(m.group())) : null;
    }

    public String getJQLFromFilter(String originalJQL) {
        Long filterId = this.getFilterId(originalJQL);
        DefaultFilter filter = DefaultFilter.getById(filterId);
        return filter != null ? filter.getJql() : null;
    }

    public JQLResponse exec(String jql, List<String> fields, List<String> expand, List<String> properties, Map<String, Object> extraOpts) {
        String actualJql = this.jqlIsAPredefinedFilter(jql) ? this.getJQLFromFilter(jql) : jql;
        HashMap<String, Object> mParams = extraOpts != null ? new HashMap<String, Object>(extraOpts) : new HashMap();
        boolean loadAll = mParams.containsKey("loadAll") ? (Boolean)mParams.remove("loadAll") : true;
        int cnfLimit = loadAll ? this.MAX_JQL : ((Number)extraOpts.getOrDefault("maxResults", 100)).intValue();
        int limitIssues = Math.min(cnfLimit, this.MAX_JQL);
        mParams.putIfAbsent("jql", actualJql);
        if (fields != null) {
            mParams.putIfAbsent("fields", fields);
        }
        if (expand != null) {
            mParams.putIfAbsent("expand", expand);
        }
        if (properties != null) {
            mParams.putIfAbsent("properties", properties);
        }
        try {
            JQLResponse jqlResponse = this.executeSearchStrategy(mParams, limitIssues);
            return this.createJQLResponseForAllIssues(jqlResponse, jqlResponse.getIssues());
        }
        catch (BadRequestToSourceException bre) {
            throw bre;
        }
        catch (Exception ex) {
            log.error("Bad data", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private JQLResponse createJQLResponseForAllIssues(JQLResponse firstPage, List<Map> issues) {
        JQLResponse jqlResponse = new JQLResponse();
        jqlResponse.setExpand(firstPage.getExpand());
        jqlResponse.setStartAt(0);
        jqlResponse.setMaxResults(issues.size());
        jqlResponse.setTotal(firstPage.getTotal());
        jqlResponse.setIssues(issues);
        jqlResponse.setNames(firstPage.getNames());
        jqlResponse.setWarningMessages(firstPage.getWarningMessages());
        return jqlResponse;
    }
}

